// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Normal Sprite Vertex Shader
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Constant buffers
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cbuffer MatrixBuffer
{
    matrix worldMatrix;
    matrix view_proj_matrix;

	float  width, height;
	float  tu_offset, tv_offset;
};


// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Structs
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
struct VertexInputType
{
    float4 position : POSITION;
    float2 tex      : TEXCOORD0;
    float4 rgba     : COLOR0;
};

struct PixelInputType
{
    float4 position : SV_POSITION;
    float2 tex      : TEXCOORD0;
    float4 rgba     : COLOR0;
};


// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Vertex Shader
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
PixelInputType Sprite_VertexShader(VertexInputType input)
{
    PixelInputType output;
    
    // Change the position vector to be 4 units for proper matrix calculations.
    input.position.w = 1.0f;

    // Calculate the position of the vertex against the world, view, and projection matrices.
    output.position = mul(input.position, worldMatrix);
    output.position = mul(output.position, view_proj_matrix);

    output.tex  = input.tex + float2(tu_offset, tv_offset);
    output.rgba = input.rgba;

    return output;
}
