/* Underwurlde:Resurrection
   Neil Walker 12/9/1999
   www.retrospec.co.uk
*/


//compiler stuff, yes consts are better...
#define VERSION "1.0.0"
#define SYSTEM "Jumping Jack 2 - Skunk McGeordie"
#define AUTHOR "Neil Walker"
//the resolutions we represent as VGA and SVGA
#define VGA_H 240
#define VGA_W 320
#define SVGA_H 480
#define SVGA_W 640
#define CONFIG_FILE "jack.cfg"
#define HI_COLOUR 16
#define MODE_GFX 1        //set_gfx_mode set to graphics
#define MODE_DOS 3        //allegro is not running

//music and sound
enum EVOLUME {QUIET=90, MEDIUMQUIET=110, MEDIUM=150, MEDIUMLOUD=200, LOUD=255};
enum EDIGIPRIORITY {LOW=90, NORMAL=128, HIGH=255};
#define MAXVOICEARRAY 256 //maximum sounds we allow to play at once

//main gameclass
class CAllegro
{
 public:
//core methods
  CAllegro();
 virtual ~CAllegro();
 void shutdown();
 void abortsystem(char*);
 void datload(struct DATAFILE**,char*,int);
 void startup();
 void console(char*,char*,char*);

protected:
 //this is the order they are called
 virtual void init_system(); //main console startup to determine available modes, etc.
 void init_allegro(); //initialise Allegro
 virtual void init_game(); //initialise game

 virtual void deinit_game(); //stop all the stuff we have started
 void deinit_allegro();
 virtual void deinit_system();

//core data
private:
 int m_mode;

//music methods
public:
 //midi
 void noMusic();
 void yesMusic();
 int getMusic();
 void playmidi(MIDI*,int,EVOLUME);
 void stopmidi();

 //digi
 void noDigi();
 void yesDigi();
 int getDigi();
 int playdigi(SAMPLE*,EVOLUME,EDIGIPRIORITY,int);
 int playdigi(SAMPLE*,EVOLUME,EDIGIPRIORITY,int,int,int);
 void pansweep(int,int,int);
 void stopdigi(int);
 void purgedigi();
 void killdigi();
 int digipos(int);
 void textmsg(char*);

//music data
protected:
 int digi_voices;
 int midi_voices;

 int nomidi; //in game midi
 volatile int nodigi; //in game digi

private:
 int voicearray[MAXVOICEARRAY]; //maximum allowed at any one time
};

