//definitions
#define MAXPOS 4472 //640 width by 7 rows hazard can go on (i.e. 639*6 + 638)
//eplayer is linked to the sprite array
enum EPLAYER {PM_LEFT=0,PM_RIGHT,PM_STILL,PM_JUMP,PM_HIT,PM_FALLHIT,PM_FALLGAP,PM_DEAD,PM_FIXED};
//gap type
enum EGAPTYPE {GAP_LEFT,GAP_RIGHT,GAP_RANDOM};

/*
Width is 640 pixels
Frames per second is 30
Required time to span width of screen 5 seconds
1 screen is 150 frames (5*30)
1 frame is 4 pixels (640/150) - actually 4.267
which gives 120 pixels per second (30*4)
man speed is same as gap
hit roof disoriented is 3/4 time for span (150/4*3) - 112 frames
drop from roof disoriented is 1/8 screen (150/8) - 18 frames
except drom from roof to bottom is 3/4

*/
//if want smoother then double all the below where used
//except gap_pixels_frame which should be 2
#define FRAME_FPS_TARGET 30       //required frame rate

#define FRAME_SCREEN_FRAMES 150 //150 frames
#define FRAME_GAP_PIXELS_FRAME 4      //pixels gap/baddies/player moves per frame -- add difficulty level to gap movement (see above) - bad name really
#define FRAME_ROOF_HIT 112   //time taken to recover from hitting room
#define FRAME_ROOF_FALL 40   //time taken to recover from falling down a gap
#define FRAME_HAZ_WAIT_MAX 60  //hazards wait random time at bottom to change position slightly every run- i.e. not always over a hole/other hazard

//simple sprite routine
//to change to a different type

//subclass for hazard,man, poppins, gap
//need to get a book I think
//don't usually derive from csprite as co-ords are not stored here

//this is the main game sprite
//all others e.g. player, gap are derived from this
//to use the static functions
class CHazard : public CSprite
{
 public:
        CHazard();
        ~CHazard() {}
        static void Add(CHazard*, int pos, int m, int anif, int*animseq,int width, int height, int num, ESPRITE type);
        static void xyToPos(int x, int y,int* pos);    //convert row/col to position (i.e. numeric)
        static void PosToxy(int pos, int* x, int* y);
        virtual void Move(int,int);
        virtual void MoveLeft(int,int);            //these are normally called by nextframe via Move(), but used as an override
        virtual void MoveRight(int,int);
        int position;   //integer 0 top left, 640*num levels - dependant upon type
 protected:
 private:
};

//player sprite
class CPlayer: public CHazard
{
 public:
        //add function sets player/computer type
        CPlayer(int left,int right,int jump1,int jump2,char*); //human player
        CPlayer(char*);      //computer player
        ~CPlayer() {}
        void Move(int,int);               //normally called by nextframe only, only useful to bypass synchronisation
        void MoveLeft();            //these are normally called by nextframe via Move(), but used as an override
        void MoveRight();
        void MoveVertical();

        int Collision(ESPRITE*,int*); //check collision of players only
        int vertical;  //vertical position 0 to PLATFORM_SPACE+PLATFORM_HEIGHT
        char* username() {return playername;}
        void dead();
        int isdead();

        int score;
        int lives;
        int bombs;
        int safes;
        EPLAYER movementoverride; //used to automove player (i.e. computer move)
        EPLAYER defaultdirection; //when not in danger direction player moves (i.e. computer)
        int defaultposition;      //where computer player goes if PM_FIXED type
        EPLAYER direction;
        int singlevoice;   //to allow a single sprite a single voice to play at any one time (useful if one action cancels another out, e.g. jumping then hitting)
 protected:
        char playername[20]; //name
        bool insafe;
 private:
        int kleft,kright,kjump1,kjump2; //key presses for movement
        int deadasageordie;
};

//gap
//only need to call hazard move left/right
class CGap: public CHazard
{
 public:
        //uses standard hazard move but must override
        CGap(EGAPTYPE dir) { gapdirection=dir; }
        ~CGap() {}

        void Move(int,int);
        void MoveLeft() {CHazard::MoveLeft(0,MAXPOS+639);}   //allowed one more level down -actually the same as hazards but needed as gaps are lower down
        void MoveRight() {CHazard::MoveRight(0,MAXPOS+639);} //allowed one more level down
        EGAPTYPE gapdirection;
};
