/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces;

import com.scs.stellarforces.MainWindow;
import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.ErrorModule;
import com.scs.stellarforces.start.StartupModule;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.awt.ImageCache;
import ssmith.lang.Functions;

public final class MainThread
extends Thread {
    private static final long ONBACK_GAP = 200L;
    private static Paint paint_black_fill = new Paint();
    private ArrayList<MyEvent> events = new ArrayList();
    protected boolean mRun = true;
    public AbstractModule module;
    public AbstractModule next_module;
    private long last_onback_pressed;
    public Canvas c;
    private long fps;
    public MainWindow window;

    static {
        paint_black_fill.setARGB(255, 0, 0, 0);
        paint_black_fill.setAntiAlias(true);
    }

    public MainThread() {
        super("MainThread");
        this.setDaemon(true);
        this.window = new MainWindow(this);
        Statics.img_cache = new ImageCache(this.window);
    }

    @Override
    public void run() {
        try {
            while (this.mRun) {
                long start = System.currentTimeMillis();
                this.updateGame();
                this.doDrawing();
                long diff = System.currentTimeMillis() - start;
                if (diff != 0L) {
                    this.fps = 1000L / diff;
                }
                Functions.delay(30L - diff);
            }
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
            JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage() + ".  Please restart", "Error", 0);
        }
        AbstractActivity.Log("MainThread ended.");
    }

    public void doDrawing() {
        this.c = new Canvas(this.window.bs.getDrawGraphics());
        this.c.getGraphics().setFont(Statics.stdfnt);
        this.c.drawRect(0.0f, 0.0f, Statics.SCREEN_WIDTH, Statics.SCREEN_HEIGHT, paint_black_fill);
        if (this.module != null) {
            this.module.doDraw(this.c, 30L);
        }
        this.window.bs.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onBackPressed() {
        ArrayList<MyEvent> arrayList = this.events;
        synchronized (arrayList) {
            this.events.clear();
        }
        if (this.module != null) {
            if (System.currentTimeMillis() > this.last_onback_pressed + 200L) {
                this.last_onback_pressed = System.currentTimeMillis();
                return this.module.onBackPressed();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MyEvent ev) {
        ArrayList<MyEvent> arrayList = this.events;
        synchronized (arrayList) {
            this.events.add(ev);
        }
    }

    public void setRunning(boolean b) {
        this.mRun = b;
    }

    public void setNextModule(AbstractModule m) {
        if (this.next_module == null || m instanceof ErrorModule) {
            this.next_module = m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGame() {
        if (this.next_module != null) {
            if (this.module != null) {
                this.module.stopped();
            }
            this.module = this.next_module;
            this.next_module = null;
            this.module.started();
            ArrayList<MyEvent> arrayList = this.events;
            synchronized (arrayList) {
                this.events.clear();
            }
        }
        if (this.module != null) {
            if (this.events.size() > 0) {
                while (this.events.size() > 0) {
                    MyEvent ev = null;
                    ArrayList<MyEvent> arrayList = this.events;
                    synchronized (arrayList) {
                        ev = this.events.remove(0);
                    }
                    try {
                        if (ev == null || !this.module.processEvent(ev)) continue;
                        arrayList = this.events;
                        synchronized (arrayList) {
                            this.events.clear();
                        }
                    }
                    catch (Exception ex) {
                        AbstractActivity.HandleError(ex);
                    }
                }
            }
            this.module.updateGame(30L);
        } else {
            this.setNextModule(new StartupModule(Statics.act));
        }
    }
}

