/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces;

import com.scs.stellarforces.MainThread;
import com.scs.stellarforces.Statics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ssmith.android.framework.MyEvent;

public class MainWindow
extends JFrame
implements MouseListener,
KeyListener,
MouseMotionListener,
WindowListener,
MouseWheelListener {
    public BufferStrategy bs;
    private MainThread thread;

    public MainWindow(MainThread t) {
        this.thread = t;
        this.setUndecorated(true);
        this.setExtendedState(6);
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        device.setFullScreenWindow(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.addMouseWheelListener(this);
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream("icon.png");
            BufferedImage bi = ImageIO.read(is);
            this.setIconImage(bi);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setVisible(true);
        this.setResizable(false);
        this.setTitle("Stellar Forces");
        this.createBufferStrategy(2);
        this.bs = this.getBufferStrategy();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 112) {
            try {
                Rectangle r = null;
                r = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                BufferedImage image = new Robot().createScreenCapture(r);
                String filename = "StellarForces_Screenshot_" + System.currentTimeMillis() + ".png";
                ImageIO.write((RenderedImage)image, "png", new File(filename));
                Statics.p("Screenshot saved as " + filename);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                ex.printStackTrace();
            }
            return;
        }
        this.thread.module.onKeyDown(ke.getKeyCode(), ke);
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 27) {
            this.thread.onBackPressed();
        } else {
            this.thread.module.onKeyUp(ke.getKeyCode(), ke);
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getButton() == 3) {
            this.thread.onBackPressed();
        } else {
            this.thread.addEvent(new MyEvent(me));
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.thread.addEvent(new MyEvent(me));
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.thread.addEvent(new MyEvent(me));
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.thread.addEvent(new MyEvent(me));
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.thread.setRunning(false);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.thread.module != null) {
            this.thread.module.mouseWheelMoved(mwe);
        }
    }
}

