/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import dsr.data.EquipmentData;
import dsr.data.UnitData;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class SingleUnitStatsModule
extends SimpleScrollingAbstractModule {
    private UnitData unit;
    private EquipmentData[] equipment;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();
    private static Paint paint_small_text = new Paint();

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_large_text.setTextSize(Statics.GetHeightScaled(0.09f));
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.06f));
        paint_small_text.setARGB(255, 255, 255, 255);
        paint_small_text.setAntiAlias(true);
        paint_small_text.setTextSize(Statics.GetHeightScaled(0.04f));
    }

    public SingleUnitStatsModule(AbstractModule ret, UnitData _unit, EquipmentData[] _equipment) {
        super(-1);
        this.mod_return_to = ret;
        this.unit = _unit;
        this.equipment = _equipment;
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        AbstractActivity act = Statics.act;
        this.root_node.detachAllChildren();
        VerticalFlowLayout layout = new VerticalFlowLayout("vfl", (float)Statics.SCREEN_HEIGHT * 0.005f);
        Label name = new Label("name", this.unit.name, null, paint_large_text);
        layout.attachChild(name);
        name = new Label("name", "Health: " + this.unit.getHealth() + "/" + this.unit.getMaxHealth(), null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "APS: " + this.unit.aps + "/" + this.unit.max_aps, null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "Shot Skill: " + this.unit.shot_skill, null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "Combat Skill: " + this.unit.combat_skill, null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "Strength: " + this.unit.strength, null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "Energy: " + this.unit.curr_energy, null, paint_normal_text);
        layout.attachChild(name);
        name = new Label("name", "Morale: " + this.unit.curr_morale, null, paint_normal_text);
        layout.attachChild(name);
        if (this.unit.can_use_equipment) {
            name = new Label("name", String.valueOf(act.getString("unit_is_carrying")) + ":-", null, paint_large_text);
            layout.attachChild(name);
            String s = GameModule.GetUnitsEquipmentAsString(this.unit, this.equipment);
            MultiLineLabel mll = new MultiLineLabel("equipment", s, null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.8f);
            layout.attachChild(mll);
        }
        this.root_node.attachChild(layout);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(layout, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        this.returnTo();
    }
}

