/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.Explosion;
import com.scs.stellarforces.graphics.GameObject;
import com.scs.stellarforces.graphics.Sparks;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.MyPointF;

public class Bullet
extends GameObject
implements IProcessable {
    private static final float SIZE = Statics.SQ_SIZE / 4.0f;
    private static final float LENGTH = (float)Statics.SCREEN_WIDTH * 0.01f;
    private MyPointF move_dir;
    private MyPointF pixel_end;
    private float max_dist;
    private float dist_so_far = 0.0f;
    private boolean explosion_at_end;
    private BufferedImage bmp;
    private boolean track;
    private MyPointF orig_cam_loc;
    private int num_of_sprites;

    public Bullet(GameModule _game, MyPointF pxl_start, MyPointF _pixel_end, boolean explode, boolean _track, String r, int num, float size) {
        super(_game, "Bullet", true, pxl_start.x, pxl_start.y, size, size, false, false);
        this.pixel_end = _pixel_end;
        this.move_dir = this.pixel_end.subtract(pxl_start).normalize().multiply(Statics.BULLET_MOVE_DIST);
        this.max_dist = this.pixel_end.subtract(pxl_start).length();
        this.bmp = GameModule.ImgCache.getImage(r, SIZE, SIZE);
        this.track = _track;
        this.explosion_at_end = explode;
        this.num_of_sprites = num;
        this.game.attachToRootNode_Top(this, true);
        this.game.addToProcess(this);
        if (this.track) {
            this.orig_cam_loc = this.game.root_cam.getActualCentre().copy();
        }
    }

    @Override
    public void process(long interpol) {
        if (this.move_dir.length() == 0.0f) {
            this.remove();
        } else {
            MyPointF act_dir = this.move_dir.multiply(interpol);
            this.adjustLocation(act_dir);
            this.dist_so_far += act_dir.length();
            this.updateGeometricState();
            if (this.dist_so_far > this.max_dist) {
                this.remove();
            } else if (this.track) {
                this.game.root_cam.lookAt(this, true);
            }
        }
    }

    private void remove() {
        this.game.removeFromProcess(this);
        if (this.explosion_at_end) {
            new Explosion(this.game, this.pixel_end.x, this.pixel_end.y, Statics.SQ_SIZE);
        } else {
            new Sparks(this.game, this.pixel_end.x, this.pixel_end.y);
        }
        if (this.track && this.orig_cam_loc != null) {
            this.game.root_cam.lookAt(this.orig_cam_loc.x, this.orig_cam_loc.y, true);
        }
        this.removeFromParent();
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            float x = this.world_bounds.left - cam.left - SIZE / 2.0f;
            float y = this.world_bounds.top - cam.top - SIZE / 2.0f;
            int i = 0;
            while (i < this.num_of_sprites) {
                g.drawImage(this.bmp, x, y, this.paint);
                x += this.move_dir.x * LENGTH;
                y += this.move_dir.y * LENGTH;
                ++i;
            }
        }
    }
}

