/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.GameObject;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;

public class CCExplosion
extends GameObject
implements IProcessable {
    private static final int DURATION = 200;
    private int current_frame = 0;
    private long timer = 200L;
    private BufferedImage[] frames = new BufferedImage[3];

    public CCExplosion(GameModule game, float pxl_centre_x, float pxl_centre_y) {
        super(game, "CCExplosion", false, pxl_centre_x, pxl_centre_y, Statics.SQ_SIZE, Statics.SQ_SIZE, false, false);
        this.frames[0] = GameModule.ImgCache.getImage("explosion5", Statics.SQ_SIZE, Statics.SQ_SIZE);
        this.frames[1] = GameModule.ImgCache.getImage("explosion6", Statics.SQ_SIZE, Statics.SQ_SIZE);
        this.frames[2] = GameModule.ImgCache.getImage("explosion7", Statics.SQ_SIZE, Statics.SQ_SIZE);
        game.attachToRootNode_Top(this, true);
        this.updateGeometricState();
        game.addToProcess(this);
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.frames[this.current_frame] != null) {
            g.drawImage(this.frames[this.current_frame], this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
        }
    }

    @Override
    public void process(long interpol) {
        this.timer -= interpol;
        if (this.timer < 0L) {
            this.timer = 200L;
            ++this.current_frame;
            if (this.current_frame >= this.frames.length) {
                this.removeFromParent();
                this.game.removeFromProcess(this);
            }
        }
    }
}

