/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.GameObject;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;

public class Ghost
extends GameObject
implements IProcessable {
    private static final int SPEED = 5;
    private BufferedImage frame;
    private float dist_moved = 0.0f;

    public Ghost(GameModule game, float pxl_centre_x, float pxl_centre_y, float pxl_size) {
        super(game, "Ghost", false, pxl_centre_x - pxl_size / 2.0f, pxl_centre_y - pxl_size / 2.0f, pxl_size, pxl_size, false, false);
        this.frame = GameModule.ImgCache.getImage("ghost", pxl_size, pxl_size);
        game.attachToRootNode_Top(this, true);
        this.updateGeometricState();
        game.addToProcess(this);
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        g.drawImage(this.frame, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
    }

    @Override
    public void process(long interpol) {
        this.setLocation(this.local_rect.left, this.local_rect.top - 5.0f);
        this.updateGeometricState();
        this.dist_moved += 5.0f;
        if (this.dist_moved > (float)Statics.SCREEN_HEIGHT) {
            this.game.removeFromProcess(this);
            this.removeFromParent();
        }
    }
}

