/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics.gui;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.gui.LogWindow;
import dsr.data.EquipmentData;
import dsr.data.UnitData;
import dsrwebserver.tables.UnitsTable;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.gui.Label;

public class StatusBarNode
extends Node {
    private GameModule game;
    private Label str_name;
    private Label str_equip;
    private static Paint paint_bigger_text = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTypeface(Statics.stdfnt);
        paint_bigger_text.setARGB(255, 255, 255, 255);
        paint_bigger_text.setAntiAlias(true);
        paint_bigger_text.setTypeface(Statics.stdfnt);
    }

    public StatusBarNode(GameModule _game) {
        super("StatNode");
        this.game = _game;
        this.str_name = new Label("Unit_Name", "", Statics.ICONS_WIDTH * 2.0f, 0.0f, LogWindow.back_col, paint_bigger_text, false);
        this.attachChild(this.str_name);
        this.str_equip = new Label("Unit_Equipment", "", Statics.ICONS_WIDTH * 2.0f, paint_bigger_text.getTextSize() * 1.2f, LogWindow.back_col, paint_normal_text, false);
        this.attachChild(this.str_equip);
    }

    public void updateStatus() {
        AbstractActivity act = Statics.act;
        UnitData current_unit = this.game.getCurrentUnit();
        this.str_name.setText("");
        this.str_equip.setText("");
        if (this.game.game_data != null) {
            if (this.game.game_data.game_status == 20) {
                if (this.game.next_to_deploy >= 0) {
                    this.str_name.append(String.valueOf(act.getString("deploying_unit")) + " " + this.game.units[this.game.next_to_deploy].order_by + ": " + this.game.units[this.game.next_to_deploy].name);
                } else {
                    this.str_name.append(act.getString("deployment_finished"));
                }
            } else if (this.game.game_data.game_status == 30 && current_unit != null) {
                String name = current_unit.name;
                if (current_unit.unit_type == 1) {
                    name = String.valueOf(name) + " (Eng)";
                }
                this.str_name.append(String.valueOf(current_unit.order_by) + " " + name + "  - APs: " + current_unit.getAPs() + " (" + current_unit.opp_fire_aps_req + ") - HP: " + current_unit.getHealth() + "/" + current_unit.max_health);
                if (this.game.game_data.is_advanced == 1 && current_unit.skillid > 0) {
                    this.str_equip.append(String.valueOf(UnitsTable.Skill2String(current_unit.skillid)) + " ");
                }
                this.str_equip.append("Prot:" + current_unit.protection);
                if (current_unit.current_item != null) {
                    EquipmentData eq = current_unit.current_item;
                    this.str_equip.append(" - " + eq.getName(true) + " ");
                } else if (current_unit.can_use_equipment) {
                    this.str_equip.append(" - * " + act.getString("nothing") + " *");
                }
            }
        } else {
            this.str_name.append("SELECT GAME");
        }
        this.str_name.updateWidth();
        this.str_equip.updateWidth();
        this.str_name.visible = this.str_name.getText().length() > 0;
        boolean bl = this.str_equip.visible = this.str_equip.getText().length() > 0;
        if ((this.str_name.getText().length() > 0 || this.str_equip.getText().length() > 0) && this.game.game_data != null) {
            if (this.game.game_data.game_status == 30) {
                if (current_unit != null) {
                    if (current_unit.getHealth() < current_unit.max_health / 2) {
                        this.str_name.setInkRGB(255, 0, 0);
                    } else if (current_unit.getHealth() < current_unit.max_health) {
                        this.str_name.setInkRGB(255, 255, 0);
                    } else {
                        this.str_name.setInkRGB(255, 255, 255);
                    }
                }
            } else {
                this.str_name.setInkRGB(255, 255, 255);
            }
        }
    }
}

