/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics.icons;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.ExpandingTextLabel;
import com.scs.stellarforces.graphics.icons.AbstractIcon;

public class CommandIcon
extends AbstractIcon {
    public static final byte SCANNER = 2;
    public static final byte CANCEL = 3;
    public static final byte PICKUP_ITEM = 4;
    public static final byte CHANGE_ITEM = 5;
    public static final byte DROP_ITEM = 6;
    public static final byte SELECT_SHOT_TYPE = 7;
    public static final byte END_TURN = 10;
    public static final byte AIMED_SHOT = 11;
    public static final byte SNAP_SHOT = 12;
    public static final byte AUTO_SHOT = 13;
    public static final byte RELOAD = 14;
    public static final byte SHOW_PRIME_MENU = 15;
    public static final byte SHOW_THROW_MENU = 16;
    public static final byte USE_MEDI_KIT_SELF = 18;
    public static final byte NEXT_UNIT = 19;
    public static final byte PREV_UNIT = 20;
    public static final byte WARNING = 21;
    public static final byte ACTIVATE = 23;
    public static final byte OPEN_DOOR = 25;
    public static final byte REMOVE_ITEM = 27;
    public static final byte ESCAPE = 29;
    public static final byte CLOSE_DOOR = 30;
    public static final byte ABSORB = 34;
    public static final byte EXPLODE = 35;
    public static final byte SPLIT = 36;
    public static final byte TEST = 37;
    public static final byte EQUIPMENT_MENU = 39;
    public static final byte NEXT_TUTORIAL = 41;
    public static final byte USE_SCANNER = 45;
    public static final byte UNDO_DEPLOY = 49;
    public static final byte USE_MEDI_KIT_OTHER = 50;
    public static final byte BUILD_STRUCTURE = 51;
    public static final byte DISMANTLE_STRUCTURE = 52;
    public static final byte LAY_EGG = 53;
    public static final byte HEAL = 54;
    public byte cmd;

    public CommandIcon(GameModule m, String col, String text, byte _cmd) {
        super(m, col, text);
        this.cmd = _cmd;
    }

    public CommandIcon(GameModule m, String text, byte _cmd) {
        this(m, "menu_frame_blue", text, _cmd);
    }

    @Override
    public String toString() {
        return "CommandIcon: " + this.cmd;
    }

    @Override
    public boolean mouseClicked() {
        Statics.act.playSound("type2");
        if (this.game.question) {
            switch (this.cmd) {
                case 2: {
                    this.game.addToHUD("Show the strategic scanner");
                    break;
                }
                case 3: {
                    this.game.addToHUD("Return to Previous menu");
                    break;
                }
                case 4: {
                    this.game.addToHUD("Lists items that the unit can pick up");
                    break;
                }
                case 5: {
                    this.game.addToHUD("Change the unit's current item");
                    break;
                }
                case 6: {
                    this.game.addToHUD("The unit will drop the item they are holding");
                    break;
                }
                case 7: {
                    this.game.addToHUD("Selects the type of shot the unit should make");
                    break;
                }
                case 11: {
                    this.game.addToHUD("Make an aimed shot (most accurate)");
                    break;
                }
                case 12: {
                    this.game.addToHUD("Make an snap shot (medium accuracy)");
                    break;
                }
                case 13: {
                    this.game.addToHUD("Make an autoshot (least accurate)");
                    break;
                }
                case 14: {
                    this.game.addToHUD("Reload the current weapon.  An ammo pack is required");
                    break;
                }
                case 15: {
                    this.game.addToHUD("Brings up the Prime Grenade menu");
                    break;
                }
                case 16: {
                    this.game.addToHUD("Aims a throw");
                    break;
                }
                case 10: {
                    this.game.addToHUD("Ends your current turn");
                    break;
                }
                case 18: {
                    this.game.addToHUD("Use the unit's medikit to heal themself");
                    break;
                }
                case 50: {
                    this.game.addToHUD("Use the unit's medikit to heal facing unit");
                    break;
                }
                case 54: {
                    this.game.addToHUD("Heal another unit");
                    break;
                }
                case 19: {
                    this.game.addToHUD("Select the next deployed unit in your squad");
                    break;
                }
                case 20: {
                    this.game.addToHUD("Select the previous deployed unit in your squad");
                    break;
                }
                case 23: {
                    this.game.addToHUD("Activate the unit's current item");
                    break;
                }
                case 25: {
                    this.game.addToHUD("Opens the door that the unit is facing");
                    break;
                }
                case 27: {
                    this.game.addToHUD("The unit puts their current item back in their pocket");
                    break;
                }
                case 29: {
                    this.game.addToHUD("Escape through the escape hatch");
                    break;
                }
                case 30: {
                    this.game.addToHUD("Closes the door that the unit is facing");
                    break;
                }
                case 34: {
                    this.game.addToHUD("Absorb a corpse for more strength");
                    break;
                }
                case 36: {
                    this.game.addToHUD("Split the blob in half");
                    break;
                }
                case 35: {
                    this.game.addToHUD("Explode cuasing damage but killing the blob");
                    break;
                }
                case 41: {
                    this.game.addToHUD("Select the next stage of the tutorial");
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    this.game.addToHUD("Shows the equipment menu");
                    break;
                }
                case 45: {
                    this.game.addToHUD("Use the distance scanner");
                    break;
                }
                case 49: {
                    this.game.addToHUD("Undo the deployment of the last deployed unit");
                    break;
                }
                case 51: {
                    this.game.addToHUD("Build a new Structure");
                    break;
                }
                case 52: {
                    this.game.addToHUD("Dismantle a Structure");
                    break;
                }
                case 53: {
                    this.game.addToHUD("Lays an egg");
                }
            }
            return true;
        }
        switch (this.cmd) {
            case 2: {
                this.game.toggleScanner();
                break;
            }
            case 3: {
                this.game.cancelMenu();
                break;
            }
            case 4: {
                this.game.showPickupItemMenu();
                break;
            }
            case 5: {
                this.game.showChangeUnitsItemMenu();
                break;
            }
            case 6: {
                this.game.dropCurrentItem();
                break;
            }
            case 7: {
                this.game.showSelectShotTypeMenu();
                break;
            }
            case 11: {
                this.game.makeAimedShot();
                break;
            }
            case 12: {
                this.game.makeSnapShot();
                break;
            }
            case 13: {
                this.game.makeAutoShot();
                break;
            }
            case 14: {
                this.game.reload();
                break;
            }
            case 15: {
                this.game.showPrimeMenu();
                break;
            }
            case 16: {
                this.game.showThrowMenu();
                break;
            }
            case 18: {
                this.game.useMedikit(true);
                break;
            }
            case 50: {
                this.game.useMedikit(false);
                break;
            }
            case 54: {
                this.game.heal();
                break;
            }
            case 19: {
                this.game.selectNextUnit();
                break;
            }
            case 20: {
                this.game.selectPrevUnit();
                break;
            }
            case 21: {
                break;
            }
            case 23: {
                this.game.activateEquipment();
                break;
            }
            case 25: {
                this.game.openDoor();
                break;
            }
            case 27: {
                this.game.askIfRemoveItem();
                break;
            }
            case 29: {
                this.game.escape();
                break;
            }
            case 30: {
                this.game.closeDoor();
                break;
            }
            case 34: {
                this.game.absorbeCorpse();
                break;
            }
            case 36: {
                this.game.splitBlob();
                break;
            }
            case 35: {
                this.game.blobAttemptExplode();
                break;
            }
            case 41: {
                this.game.nextTutorial();
                break;
            }
            case 37: {
                this.game.root_node.attachChild(new ExpandingTextLabel(this.game.getCurrentUnit().model, "20"));
                this.game.root_node.updateGeometricState();
                break;
            }
            case 39: {
                this.game.showEquipmentMenu();
                break;
            }
            case 45: {
                this.game.useStardriveScanner();
                break;
            }
            case 49: {
                this.game.undoDeployment();
                break;
            }
            case 51: {
                this.game.showBuildStructureMenu();
                break;
            }
            case 52: {
                this.game.dismantleStructure();
                break;
            }
            case 53: {
                this.game.layEgg();
                break;
            }
            default: {
                throw new RuntimeException("Unknown command: " + this.cmd);
            }
        }
        return true;
    }
}

