/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.message;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.message.SendMessageModule;
import com.scs.stellarforces.message.ViewMessageModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import java.io.UnsupportedEncodingException;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractMultilineOptionsModule2;
import ssmith.lang.NumberFunctions;

public class ListMessagesModule
extends AbstractMultilineOptionsModule2 {
    private DataTable messages_dt;
    private static Paint paint_free_text = new Paint();
    private static Paint paint_background = new Paint();

    static {
        paint_free_text.setARGB(255, 0, 0, 0);
        paint_free_text.setAntiAlias(true);
        paint_free_text.setTypeface(Statics.stdfnt);
        paint_background.setARGB(155, 255, 255, 255);
        paint_background.setAntiAlias(true);
    }

    public ListMessagesModule(AbstractActivity act) {
        super(act, 4, paint_background, paint_free_text, -1, false, "Messages", (float)Statics.SCREEN_WIDTH * 0.9f, true);
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        AbstractActivity act = Statics.act;
        if (this.messages_dt == null) {
            this.showPleaseWait("Getting messages...");
            try {
                WGet_SF wc = new WGet_SF(act, null, "cmd=get_messages&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD));
                String response = wc.getResponse();
                this.messages_dt = new DataTable(response);
                this.dismissPleaseWait();
            }
            catch (Exception ex) {
                this.dismissPleaseWait();
                AbstractActivity.HandleError(ex);
            }
        } else {
            this.setOptions();
        }
    }

    @Override
    public void getOptions() {
        this.addOption("New Message");
        if (this.messages_dt != null) {
            this.messages_dt.moveBeforeFirst();
            while (this.messages_dt.moveNext()) {
                StringBuffer s = new StringBuffer();
                try {
                    s.append(String.valueOf(this.messages_dt.getString("DateCreated")) + " ");
                    if (this.messages_dt.getInt("FromID") > 0) {
                        s.append("From " + AbstractCommFuncs.URLDecodeString(this.messages_dt.getString("FromName")) + " ");
                    }
                    s.append(" - " + AbstractCommFuncs.URLDecodeString(this.messages_dt.getString("Subject")));
                }
                catch (UnsupportedEncodingException ex) {
                    AbstractActivity.HandleError(ex);
                }
                if (this.messages_dt.getInt("Read") == 0) {
                    s.append(" [UNREAD]");
                } else {
                    s.append(" [read]");
                }
                this.addOption(s.toString(), this.messages_dt.getInt("MessageID"));
            }
        }
        this.addOption("New Message");
    }

    @Override
    public void optionSelected(int idx) {
        AbstractActivity act = Statics.act;
        int id = NumberFunctions.ParseInt(super.getActionCommand(idx));
        if (this.messages_dt.find("MessageID", id)) {
            this.getMainThread().setNextModule(new ViewMessageModule(act, this, this.messages_dt));
        } else {
            this.getMainThread().setNextModule(new SendMessageModule(act, this, "", "", ""));
        }
    }
}

