/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.message;

import com.scs.stellarforces.Statics;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.WGet_SF;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.ErrorReporter;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.GUIFunctions;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.gui.TextBox;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class SendMessageModule
extends SimpleScrollingAbstractModule {
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.8f;
    private static final float ICON_HEIGHT = Statics.SCREEN_HEIGHT / 7;
    private static final String CMD_TO = "to";
    private static final String CMD_SUBJECT = "subject";
    private static final String CMD_MSG = "msg";
    private Label lbl_to;
    private Label lbl_subject;
    private MultiLineLabel mll_msg;
    private TextBox txt_to;
    private TextBox txt_subject;
    private Button cmd_edit_msg;
    private Button cmd_send;
    private String to;
    private String subject;
    private String msg = "";
    private String reply_text;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_large_text.setTextSize(GUIFunctions.GetTextSizeToFit("stephen.carlylesmith@googlemail.com", ICON_WIDTH, ICON_HEIGHT));
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(paint_large_text.getTextSize() / 2.0f);
    }

    public SendMessageModule(AbstractActivity act, AbstractModule return_to, String _to, String _subject, String _reply_text) {
        super(-1);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.mod_return_to = return_to;
        this.to = _to;
        this.subject = _subject;
        this.reply_text = _reply_text;
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        if (Statics.data.containsKey(CMD_TO)) {
            this.to = Statics.data.get(CMD_TO);
        } else if (Statics.data.containsKey(CMD_SUBJECT)) {
            this.subject = Statics.data.get(CMD_SUBJECT);
        } else if (Statics.data.containsKey(CMD_MSG)) {
            this.msg = Statics.data.get(CMD_MSG);
        }
        Statics.data.clear();
        this.root_node.detachAllChildren();
        BufferedImage bmp = Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT);
        this.lbl_to = new Label(CMD_TO, "To:", ICON_WIDTH, ICON_HEIGHT, null, paint_large_text, false);
        this.txt_to = new TextBox(CMD_TO, this.to, null, paint_large_text, -1, bmp);
        this.lbl_subject = new Label(CMD_SUBJECT, "Subject:", ICON_WIDTH, ICON_HEIGHT, null, paint_large_text, false);
        this.txt_subject = new TextBox(CMD_SUBJECT, this.subject, null, paint_large_text, -1, bmp);
        this.mll_msg = new MultiLineLabel(CMD_MSG, this.msg, null, paint_large_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
        this.cmd_edit_msg = new Button("OK", "Edit Message Body", null, paint_large_text, bmp);
        this.cmd_send = new Button("OK", "Send Message", null, paint_large_text, bmp);
        VerticalFlowLayout layout = new VerticalFlowLayout("Menu", 5.0f);
        layout.attachChild(this.lbl_to);
        layout.attachChild(this.txt_to);
        layout.attachChild(this.lbl_subject);
        layout.attachChild(this.txt_subject);
        layout.attachChild(this.mll_msg);
        layout.attachChild(this.cmd_edit_msg);
        layout.attachChild(this.cmd_send);
        this.root_node.attachChild(layout);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(layout, true);
        if (this.reply_text.length() > 0) {
            this.msg.length();
        }
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c == this.txt_to) {
            inputComponent = this.txt_to;
        } else if (c == this.txt_subject) {
            inputComponent = this.txt_subject;
        } else if (c == this.cmd_edit_msg) {
            inputComponent = this.cmd_edit_msg;
        } else if (c == this.cmd_send) {
            String msg_text = this.mll_msg.getText().trim();
            if (msg_text.length() > 0) {
                this.showPleaseWait("Sending message...");
                try {
                    WGet_SF wc;
                    String response;
                    try {
                        if (this.reply_text.length() > 0) {
                            this.reply_text = "> " + this.reply_text;
                            this.reply_text = this.reply_text.replaceAll("\n", "\n> ");
                            msg_text = String.valueOf(msg_text) + "\n\n" + this.reply_text;
                        }
                    }
                    catch (Exception ex) {
                        ErrorReporter.getInstance().handleSilentException(ex);
                    }
                    if ((response = (wc = new WGet_SF(act, null, "cmd=send_message&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&toname=" + AbstractCommFuncs.URLEncodeString(this.txt_to.getText()) + "&subject=" + AbstractCommFuncs.URLEncodeString(this.txt_subject.getText()) + "&msg=" + AbstractCommFuncs.URLEncodeString(msg_text))).getResponse()).length() == 0 || response.equalsIgnoreCase("OK")) {
                        this.dismissPleaseWait();
                        this.showToast("Message Sent");
                    } else {
                        this.dismissPleaseWait();
                        this.showToast(response);
                    }
                }
                catch (Exception ex) {
                    AbstractActivity.HandleError(ex);
                }
                this.returnTo();
            } else {
                this.showToast("There is no message text!");
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode) {
        if (resultCode == 1) {
            this.started();
        }
    }
}

