/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.equip;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.ErrorModule;
import com.scs.stellarforces.start.equip.SelectArmourModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.EquipmentDataComms;
import dsr.comms.UnitDataComms;
import dsr.comms.WGet_SF;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.UnitData;
import java.util.ArrayList;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractPleaseWaitModule;
import ssmith.android.framework.modules.ConfirmModule;

public class GetEquipmentDataModule
extends AbstractPleaseWaitModule {
    private static final String CONFIRM_USE_DEF_EQUIPMENT = "use_def_equipment";
    private GameData gamedata;
    private DataTable available_armour_dt;
    private DataTable available_equip_dt;
    private ArrayList<UnitData> units;

    public GetEquipmentDataModule(AbstractActivity _act, GameData _gamedata) {
        super(_act, 2);
        this.gamedata = _gamedata;
        this.setBackground("space1.jpg");
        this.start();
    }

    @Override
    public void run() {
        AbstractActivity act = Statics.act;
        try {
            this.getUnitData();
            super.displayMessage("Getting unit's equipment data...");
            WGet_SF wc = new WGet_SF(act, this, EquipmentDataComms.GetEquipmentDataRequest(this.gamedata.game_id, this.gamedata.gamecode));
            String response = wc.getResponse();
            if (response.length() > 0) {
                SelectArmourModule.bought_equipment = EquipmentDataComms.DecodeEquipmentDataResponse(null, this.units, response);
                super.displayMessage("Getting equipment list...");
                wc = new WGet_SF(act, this, "cmd=equipment_list&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gid=" + this.gamedata.game_id);
                response = wc.getResponse();
                if (response.length() > 0) {
                    this.available_equip_dt = new DataTable(response);
                    super.displayMessage("Getting armour list...");
                    wc = new WGet_SF(act, this, "cmd=armour_list&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gid=" + this.gamedata.game_id);
                    response = wc.getResponse();
                    if (response.length() > 0) {
                        this.available_armour_dt = new DataTable(response);
                        if (this.gamedata.creds > 0) {
                            boolean already_equipped = false;
                            EquipmentData[] equipmentDataArray = SelectArmourModule.bought_equipment;
                            int n = SelectArmourModule.bought_equipment.length;
                            int n2 = 0;
                            while (n2 < n) {
                                UnitData unit;
                                EquipmentData eq = equipmentDataArray[n2];
                                if (eq.getUnitID() > 0 && (unit = UnitData.GetUnitDataFromID(this.units, eq.getUnitID())).getSide() == this.gamedata.our_side) {
                                    already_equipped = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!already_equipped && this.gamedata.is_camp_game == 0) {
                                this.getMainThread().setNextModule(new ConfirmModule(act, this, "Use Default Equipment?", "Would you like to automatically equip with the standard equipment for this mission?", "space1.jpg", CONFIRM_USE_DEF_EQUIPMENT));
                                return;
                            }
                        }
                        SelectArmourModule sel_armour = new SelectArmourModule(act, this.gamedata, this.units, this.available_armour_dt, this.available_equip_dt);
                        super.getMainThread().setNextModule(sel_armour);
                        return;
                    }
                }
            }
            super.getMainThread().setNextModule(new ErrorModule(act, 4, "Failed!", "Sorry, I failed to get the equipment data."));
        }
        catch (Exception ex) {
            this.getMainThread().setNextModule(new ErrorModule(act, 4, ex));
        }
    }

    private void getUnitData() throws Exception {
        super.displayMessage("Getting unit data...");
        int count = 0;
        Exception last_error = null;
        while (true) {
            if (++count >= 3) {
                throw last_error;
            }
            try {
                WGet_SF wc = new WGet_SF(Statics.act, this, UnitDataComms.GetUnitDataRequest(this.gamedata.game_id, this.gamedata.gamecode, Statics.LAST_LOGIN, Statics.LAST_PWD));
                String response = wc.getResponse();
                if (response.length() <= 0) continue;
                this.units = UnitDataComms.DecodeUnitDataResponse(response);
                return;
            }
            catch (Exception ex) {
                last_error = ex;
                continue;
            }
            break;
        }
    }

    @Override
    public void started() {
        AbstractActivity act = Statics.act;
        if (Statics.data.containsKey(CONFIRM_USE_DEF_EQUIPMENT)) {
            String s = Statics.data.get(CONFIRM_USE_DEF_EQUIPMENT);
            Statics.data.clear();
            if (s.equalsIgnoreCase("yes")) {
                this.loadStdEquipment(this.units, this.available_armour_dt, this.available_equip_dt);
            }
            SelectArmourModule sel_armour = new SelectArmourModule(act, this.gamedata, this.units, this.available_armour_dt, this.available_equip_dt);
            super.getMainThread().setNextModule(sel_armour);
        }
    }

    private void loadStdEquipment(ArrayList<UnitData> units, DataTable armour_dt, DataTable equipment_dt) {
        for (UnitData unit : units) {
            if (unit.getSide() != this.gamedata.our_side || !unit.can_use_equipment) continue;
            armour_dt.find("Name", "Light");
            unit.armour_type_id = armour_dt.getShort("ArmourTypeID");
            unit.protection = armour_dt.getShort("Protection");
        }
        String[] EQUIPMENT = new String[]{"SP30", "AP50", "Medikit", "Smokegrenade", "nervegas"};
        int i = 0;
        while (i < EQUIPMENT.length) {
            for (UnitData unit : units) {
                if (unit.getSide() == this.gamedata.our_side && unit.can_use_equipment && !this.addEquipment(unit.unitid, EQUIPMENT[i], armour_dt, equipment_dt)) break;
            }
            ++i;
        }
    }

    private boolean addEquipment(int unitid, String code, DataTable armour_dt, DataTable equipment_dt) {
        if (equipment_dt.find("Code", code)) {
            int cost;
            int creds_remaining = GetEquipmentDataModule.GetCredsRemaining(this.gamedata, this.units, armour_dt, equipment_dt);
            if (creds_remaining < (cost = equipment_dt.getInt("Cost"))) {
                return false;
            }
            EquipmentData new_eq = new EquipmentData();
            new_eq.equip_id = -1;
            new_eq.setName(equipment_dt.getString("Name"));
            new_eq.equipment_type_id = equipment_dt.getInt("EquipmentTypeID");
            new_eq.setUnitID(unitid);
            new_eq.setAmmo(equipment_dt.getByte("AmmoCapacity"));
            GetEquipmentDataModule.AddEquipmentRec(new_eq);
            return true;
        }
        return true;
    }

    public static void AddEquipmentRec(EquipmentData new_rec) {
        EquipmentData[] new_data = new EquipmentData[SelectArmourModule.bought_equipment.length + 1];
        int i = 0;
        while (i < SelectArmourModule.bought_equipment.length) {
            new_data[i] = SelectArmourModule.bought_equipment[i];
            ++i;
        }
        new_data[SelectArmourModule.bought_equipment.length] = new_rec;
        SelectArmourModule.bought_equipment = new_data;
    }

    public static int GetCredsRemaining(GameData gamedata, ArrayList<UnitData> units, DataTable armour_dt, DataTable equip_dt) {
        equip_dt.saveCurrentPos();
        int total = 0;
        for (UnitData unit : units) {
            if (unit.getSide() != gamedata.our_side || unit.armour_type_id <= 0) continue;
            if (armour_dt.find("ArmourTypeID", unit.armour_type_id)) {
                total += armour_dt.getInt("cost");
                continue;
            }
            throw new RuntimeException("Armour " + unit.protection + " not found!");
        }
        EquipmentData[] equipmentDataArray = SelectArmourModule.bought_equipment;
        int n = SelectArmourModule.bought_equipment.length;
        int n2 = 0;
        while (n2 < n) {
            UnitData unit;
            EquipmentData eq = equipmentDataArray[n2];
            if (!eq.destroyed && eq.getUnitID() > 0 && (unit = UnitData.GetUnitDataFromID(units, eq.getUnitID())).getSide() == gamedata.our_side) {
                if (equip_dt.find("EquipmentTypeID", eq.equipment_type_id)) {
                    total += equip_dt.getInt("Cost");
                } else {
                    eq.destroyed = true;
                }
            }
            ++n2;
        }
        equip_dt.restoreCurrentPos();
        return gamedata.creds - total;
    }

    public int getTotalCreds() {
        return this.gamedata.creds;
    }
}

