/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.equip;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.AllUnitStatsModule;
import com.scs.stellarforces.start.CurrentGameDetailsModule;
import com.scs.stellarforces.start.equip.ArmourHelpModule;
import com.scs.stellarforces.start.equip.ArmourSelectionControl;
import com.scs.stellarforces.start.equip.EquipUnitsModule3;
import com.scs.stellarforces.start.equip.GetEquipmentDataModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.UnitDataComms;
import dsr.comms.WGet_SF;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.UnitData;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.util.Browser;

public class SelectArmourModule
extends SimpleScrollingAbstractModule {
    private static final float GAP = (float)Statics.SCREEN_WIDTH * 0.01f;
    private ArrayList<UnitData> units;
    private Button finished;
    private Button help_button;
    private Button finished2;
    private Button unit_stats;
    private Button game_details;
    private Button armour_stats;
    private Button mission_file;
    private DataTable equipment_dt;
    private DataTable armour_dt;
    public static EquipmentData[] bought_equipment;
    private GameData game_data;
    private Label creds_left;
    private int creds_remaining;
    private int num_units;
    private AllUnitStatsModule stats_mod;
    private static Paint paint_normal_text;

    static {
        paint_normal_text = new Paint();
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.065f));
    }

    public SelectArmourModule(AbstractActivity act, GameData _gamedata, ArrayList<UnitData> _units, DataTable _armour_dt, DataTable _equip_dt) {
        super(2);
        this.game_data = _gamedata;
        this.units = _units;
        this.armour_dt = _armour_dt;
        this.equipment_dt = _equip_dt;
        this.setBackground("space1.jpg");
        this.root_node.removeAllChildren();
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", GAP);
        this.creds_left = new Label("creds_left", "Filled in later..", null, paint_normal_text, false);
        vfl.attachChild(this.creds_left);
        HorizontalFlowGridLayout hfgl2 = new HorizontalFlowGridLayout("hfgl", (float)Statics.SCREEN_WIDTH * 0.02f);
        this.finished = new Button("Buy Selected Armour", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH * 0.45f, Statics.GetStdButtonHeight()));
        hfgl2.attachChild(this.finished);
        this.help_button = new Button("Help", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH * 0.45f, Statics.GetStdButtonHeight()));
        hfgl2.attachChild(this.help_button);
        vfl.attachChild(hfgl2);
        this.num_units = 0;
        for (UnitData unit : this.units) {
            if (unit.getSide() != this.game_data.our_side || !unit.can_use_equipment || unit.can_deploy <= 0 || unit.can_equip <= 0) continue;
            ArmourSelectionControl unit_ctrl = new ArmourSelectionControl(unit, this.armour_dt, GAP, this.game_data);
            vfl.attachChild(unit_ctrl);
            ++this.num_units;
        }
        if (this.num_units == 0) {
            this.getMainThread().setNextModule(new EquipUnitsModule3(act, this, this.game_data, this.units, this.armour_dt, this.equipment_dt, this.num_units));
            return;
        }
        HorizontalFlowGridLayout hfgl = new HorizontalFlowGridLayout("hfgl", (float)Statics.SCREEN_WIDTH * 0.02f);
        this.unit_stats = new Button("Unit\nStats", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.23f, (float)Statics.SCREEN_HEIGHT / 8.0f));
        hfgl.attachChild(this.unit_stats);
        this.armour_stats = new Button("Armour\nStats", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.23f, (float)Statics.SCREEN_HEIGHT / 8.0f));
        hfgl.attachChild(this.armour_stats);
        this.game_details = new Button("Game\nDetails", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.23f, (float)Statics.SCREEN_HEIGHT / 8.0f));
        hfgl.attachChild(this.game_details);
        this.mission_file = new Button("Mission\nFile", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.23f, (float)Statics.SCREEN_HEIGHT / 8.0f));
        hfgl.attachChild(this.mission_file);
        hfgl.updateGeometricState();
        vfl.attachChild(hfgl);
        this.finished2 = new Button("Buy Selected Armour", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH * 0.95f, Statics.GetStdButtonHeight()));
        vfl.attachChild(this.finished2);
        vfl.updateGeometricState();
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
        this.updateCreds();
    }

    @Override
    public void started() {
        if (this.game_data.creds <= 0) {
            try {
                this.finished();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.updateCreds();
    }

    private void finished() throws UnknownHostException, IOException {
        AbstractActivity act = Statics.act;
        this.saveArmour();
        this.getMainThread().setNextModule(new EquipUnitsModule3(act, this, this.game_data, this.units, this.armour_dt, this.equipment_dt, this.num_units));
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c == this.finished || c == this.finished2) {
            this.finished();
        } else if (c instanceof Label) {
            this.showUnitStats();
        } else if (c == this.help_button) {
            ArmourHelpModule mod = new ArmourHelpModule(act, this);
            this.getMainThread().setNextModule(mod);
        } else if (c == this.unit_stats) {
            this.showUnitStats();
        } else if (c == this.game_details) {
            CurrentGameDetailsModule mod = new CurrentGameDetailsModule(act, this, this.game_data, false);
            this.getMainThread().setNextModule(mod);
        } else if (c == this.mission_file) {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + this.game_data.mission_type + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        } else if (c == this.armour_stats) {
            String url = "http://www.stellarforces.com/dsr/armourdetails.cls";
            Browser.OpenBrowser(url);
        } else {
            ArmourSelectionControl parent = (ArmourSelectionControl)c.getParent();
            parent.selectArmour(c);
            this.updateCreds();
        }
    }

    private void saveArmour() throws UnknownHostException, IOException {
        AbstractActivity act = Statics.act;
        try {
            try {
                this.showPleaseWait("Saving armour...");
                StringBuffer str = new StringBuffer();
                for (UnitData unit : this.units) {
                    if (unit.getSide() != this.game_data.our_side) continue;
                    String req = UnitDataComms.GetUnitUpdateRequest(unit);
                    str.append(String.valueOf(req) + "~");
                }
                if (str.length() > 0) {
                    new WGet_SF(act, null, str.toString());
                }
            }
            catch (Exception ex) {
                this.dismissPleaseWait();
                this.showToast(ex.toString());
                this.dismissPleaseWait();
            }
        }
        finally {
            this.dismissPleaseWait();
        }
    }

    private void showUnitStats() {
        AbstractActivity act = Statics.act;
        if (this.stats_mod == null) {
            this.stats_mod = new AllUnitStatsModule(act, this, this.game_data, this.units, null);
        }
        this.getMainThread().setNextModule(this.stats_mod);
    }

    private void updateCreds() {
        this.creds_remaining = GetEquipmentDataModule.GetCredsRemaining(this.game_data, this.units, this.armour_dt, this.equipment_dt);
        if (this.num_units != 0) {
            this.creds_left.setText("Buy Armour (Creds Left: " + this.creds_remaining + ", " + this.creds_remaining / this.num_units + " per unit)");
        }
    }
}

