/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.joingame;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.GenericMessageModule;
import com.scs.stellarforces.start.joingame.NewGameDetailsModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import java.io.IOException;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractOptionsModule2;

public class ListAvailableGamesModule
extends AbstractOptionsModule2 {
    private static Paint paint_text = new Paint();
    private static Paint paint_title = new Paint();
    private DataTable new_games;

    static {
        paint_text.setARGB(255, 255, 255, 255);
        paint_text.setAntiAlias(true);
        paint_title.setARGB(255, 200, 200, 200);
        paint_title.setAntiAlias(true);
    }

    public ListAvailableGamesModule(AbstractActivity act) {
        super(act, 9, 1, paint_text, "lumin_green_button2", -1, false, "Available Games", true);
        paint_text.setTypeface(Statics.stdfnt);
        paint_title.setTypeface(Statics.bigfnt);
        this.setBackground("space1.jpg");
    }

    @Override
    public void getOptions() {
        AbstractActivity act = Statics.act;
        this.showPleaseWait("Getting available games...");
        try {
            try {
                String cmd = "cmd=new_games_list&comms_version=" + Statics.COMMS_VERSION + "&android_version=" + 1.4f + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
                WGet_SF wget = new WGet_SF(act, null, cmd);
                String response = wget.getResponse();
                this.new_games = new DataTable(response);
                while (this.new_games.moveNext()) {
                    if (this.new_games.containsColumn("ForUs") && this.new_games.getString("ForUs").equalsIgnoreCase("1")) {
                        this.addOption(String.valueOf(this.new_games.getString("Player1Name")) + " is waiting for YOU!", this.new_games.getInt("GameRequestID"));
                        continue;
                    }
                    this.addOption(String.valueOf(this.new_games.getString("MissionName")) + " (vs. " + this.new_games.getString("Player1Name") + ")", this.new_games.getInt("GameRequestID"));
                }
                if (!this.areThereAnyOptions()) {
                    this.getMainThread().setNextModule(new GenericMessageModule(act, 10, "No Available Games", "Sorry, there are currently no games waiting for players.\n\nPress the screen to start a new game."));
                }
            }
            catch (IOException ex) {
                this.showToast("Error getting games.");
                this.returnTo();
                this.dismissPleaseWait();
            }
        }
        finally {
            this.dismissPleaseWait();
        }
    }

    @Override
    public void optionSelected(int idx) {
        AbstractActivity act = Statics.act;
        String cmd = this.getActionCommand(idx);
        if (this.new_games.find("GameRequestID", cmd)) {
            NewGameDetailsModule mod = null;
            mod = new NewGameDetailsModule(act, this, this.new_games.getInt("GameRequestID"), this.new_games);
            this.getMainThread().setNextModule(mod);
        }
    }

    @Override
    public void doDraw(Canvas c, long interpol) {
        super.doDraw(c, interpol);
    }
}

