/*
 * Decompiled with CFR 0.152.
 */
package dsr.comms;

import java.util.ArrayList;
import ssmith.lang.NumberFunctions;

public class DataTable
extends ArrayList<String[]> {
    private static final long serialVersionUID = 1L;
    private String[] col_names;
    private int current_row = 0;
    private int saved_row = -1;
    private int push_row = -1;
    private String data_preview;

    public DataTable(String data) {
        this.data_preview = data;
        if (this.data_preview.length() > 40) {
            this.data_preview = this.data_preview.substring(0, 39);
        }
        String[] lines = data.split("\n");
        this.col_names = lines[0].split("\\|", -1);
        int i = 1;
        while (i < lines.length) {
            String[] fields = lines[i].split("\\|", -1);
            if (NumberFunctions.mod(fields.length - this.col_names.length) <= 1) {
                this.add(fields);
            }
            ++i;
        }
        this.moveBeforeFirst();
    }

    public boolean moveNext() {
        ++this.current_row;
        return this.current_row < this.size();
    }

    public boolean movePrev() {
        --this.current_row;
        return this.current_row >= 0;
    }

    public void moveFirst() {
        this.current_row = 0;
    }

    public void moveBeforeFirst() {
        this.current_row = -1;
    }

    public void moveLast() {
        this.current_row = this.size() - 1;
    }

    public int getInt(String field) {
        return NumberFunctions.ParseInt(this.getString(field));
    }

    public void setInt(String field, int val) {
        this.setString(field, "" + val);
    }

    public byte getByte(String field) {
        return Byte.parseByte(this.getString(field));
    }

    public short getShort(String field) {
        return Short.parseShort(this.getString(field));
    }

    public String getString(String field) {
        if (this.current_row < 0) {
            throw new RuntimeException("Data not at valid row! (" + this.current_row + ")");
        }
        int i = 0;
        while (i < this.col_names.length) {
            if (this.col_names[i].equalsIgnoreCase(field)) {
                String[] data = (String[])this.get(this.current_row);
                return data[i];
            }
            ++i;
        }
        throw new RuntimeException("Field '" + field + "' not found in '" + this.data_preview + "'!");
    }

    public void setString(String field, String val) {
        if (this.current_row < 0) {
            throw new RuntimeException("Data not at valid row! (" + this.current_row + ")");
        }
        int i = 0;
        while (i < this.col_names.length) {
            if (this.col_names[i].equalsIgnoreCase(field)) {
                String[] data = (String[])this.get(this.current_row);
                data[i] = val;
                this.remove(this.current_row);
                this.add(this.current_row, data);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Field '" + field + "' not found!");
    }

    public boolean find(String col, int val) {
        return this.find(col, "" + val);
    }

    public boolean find(String col1, String val1, String col2, String val2) {
        this.moveBeforeFirst();
        while (this.moveNext()) {
            if (!this.getString(col1).equalsIgnoreCase(val1) || !this.getString(col2).equalsIgnoreCase(val2)) continue;
            return true;
        }
        return false;
    }

    public boolean find(String col, String val) {
        this.moveBeforeFirst();
        while (this.moveNext()) {
            if (!this.getString(col).equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public void moveTo(int idx) {
        this.current_row = idx;
    }

    public void saveCurrentPos() {
        this.saved_row = this.current_row;
    }

    public void restoreCurrentPos() {
        this.current_row = this.saved_row;
    }

    public boolean containsColumn(String name) {
        int i = 0;
        while (i < this.col_names.length) {
            if (this.col_names[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void pushRow() {
        this.push_row = this.current_row;
    }

    public void popRow() {
        this.current_row = this.push_row;
        this.push_row = -1;
    }

    public void removeCurrentRow() {
        super.remove(this.current_row);
    }
}

