/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework.modules;

import com.scs.stellarforces.Statics;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.lang.GeometryFuncs;

public abstract class AbstractComplexModule
extends AbstractModule {
    private static final float MIN_DRAG_DIST = (float)Statics.SCREEN_HEIGHT / 30.0f;
    private boolean is_down = false;
    private MyPointF act_start_drag = new MyPointF();
    private boolean is_dragging = false;
    protected boolean dont_scroll_lr = false;

    public AbstractComplexModule(int am) {
        super(am);
    }

    @Override
    public boolean processEvent(MyEvent ev) throws Exception {
        if (ev.getAction() == 501 && !this.is_down) {
            this.is_down = true;
            this.act_start_drag.x = ev.getX();
            this.act_start_drag.y = ev.getY();
        } else if (ev.getAction() == 506) {
            float offy;
            float offx = this.act_start_drag.x - ev.getX();
            double dist = GeometryFuncs.distance(0.0f, 0.0f, offx, offy = this.act_start_drag.y - ev.getY());
            if (dist > (double)MIN_DRAG_DIST || this.is_dragging) {
                if (this.dont_scroll_lr) {
                    offx = 0.0f;
                }
                this.drag(offx, offy);
                this.rootCamMoved(offx, offy);
                this.is_dragging = true;
                this.act_start_drag.x = ev.getX();
                this.act_start_drag.y = ev.getY();
            }
        } else if (ev.getAction() == 502) {
            this.is_down = false;
            if (!this.is_dragging) {
                float y;
                float x = ev.getX() + this.stat_cam.left;
                ArrayList<Geometry> colls = this.stat_node.getCollidersAt(x, y = ev.getY() + this.stat_cam.top);
                if (colls.size() > 0) {
                    int i = colls.size() - 1;
                    while (i >= 0) {
                        Geometry g = colls.get(i);
                        if (this.componentClicked(g)) {
                            return true;
                        }
                        --i;
                    }
                }
                if ((colls = this.root_node.getCollidersAt(x = ev.getX() + this.root_cam.left, y = ev.getY() + this.root_cam.top)).size() > 0) {
                    for (Geometry g : colls) {
                        if (!this.componentClicked(g)) continue;
                        return true;
                    }
                }
            } else {
                this.is_dragging = false;
            }
        }
        return false;
    }

    private void drag(float offx, float offy) {
        this.root_cam.moveCam(offx, offy);
    }

    public abstract boolean componentClicked(Geometry var1);

    public void rootCamMoved(float offx, float offy) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.dont_scroll_lr) {
            this.drag(0.0f, mwe.getWheelRotation() * 30);
        }
    }
}

