/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d;

import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.PointF;
import ssmith.android.compatibility.RectF;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.shapes.Geometry;

public abstract class Spatial {
    private static final float MIN_SIZE = 0.01f;
    protected RectF world_bounds = new RectF();
    public PointF parent_world_coords = new PointF();
    public Node parent = null;
    protected String name;
    public boolean visible = true;
    public boolean collides = true;
    public boolean needs_updating = false;
    private MyPointF centre_tmp = new MyPointF();

    public Spatial(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    protected void getParentWorldCoords() {
        if (this.parent != null) {
            this.parent_world_coords.x = this.getParent().world_coords.x;
            this.parent_world_coords.y = this.getParent().world_coords.y;
        } else {
            this.parent_world_coords.x = 0.0f;
            this.parent_world_coords.y = 0.0f;
        }
    }

    protected void ensureWorldBoundsNotEmpty() {
        if (this.world_bounds.right <= this.world_bounds.left) {
            this.world_bounds.right = this.world_bounds.left + 0.01f;
        }
        if (this.world_bounds.bottom <= this.world_bounds.top) {
            this.world_bounds.bottom = this.world_bounds.top + 0.01f;
        }
    }

    public abstract boolean intersects(Spatial var1);

    public abstract boolean contains(float var1, float var2);

    public String toString() {
        return String.valueOf(this.name) + "[WB: " + this.world_bounds.left + ", " + this.world_bounds.top + ", " + this.world_bounds.right + ", " + this.world_bounds.bottom + "]";
    }

    public RectF getWorldBounds() {
        return this.world_bounds;
    }

    public void setParent(Node n) {
        this.parent = n;
    }

    public ArrayList<Geometry> getColliders(Node node) {
        return this.getColliders(node, new ArrayList<Geometry>());
    }

    private ArrayList<Geometry> getColliders(Node root_node, ArrayList<Geometry> list_of_colliders) {
        if (this != root_node && root_node.collides && this.intersects(root_node)) {
            for (Spatial child : root_node.getChildren()) {
                if (!child.collides || !this.intersects(child)) continue;
                if (child instanceof Node) {
                    this.getColliders((Node)child, list_of_colliders);
                    continue;
                }
                list_of_colliders.add((Geometry)child);
            }
        }
        return list_of_colliders;
    }

    public Node getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
            this.parent = null;
        }
    }

    public abstract float getHeight();

    public abstract float getWidth();

    public abstract void doDraw(Canvas var1, Camera var2, long var3);

    public abstract void updateGeometricState();

    public abstract void setLocation(float var1, float var2);

    public void setByLTRB(float l, float t, float r, float b) {
        this.setLocation(l, t);
        this.setSize(r - l, b - t);
    }

    public void setByLTWH(float l, float t, float w, float h) {
        this.setLocation(l, t);
        this.setSize(w, h);
    }

    public abstract void setSize(float var1, float var2);

    public float getWorldCentreX() {
        return (this.world_bounds.left + this.world_bounds.right) / 2.0f;
    }

    public float getWorldCentreY() {
        return (this.world_bounds.top + this.world_bounds.bottom) / 2.0f;
    }

    public float getWorldX() {
        return this.world_bounds.left;
    }

    public float getWorldY() {
        return this.world_bounds.top;
    }

    public float getScreenX(Camera cam) {
        return this.world_bounds.left - cam.left;
    }

    public float getScreenY(Camera cam) {
        return this.world_bounds.top - cam.top;
    }

    public MyPointF getWorldCentre_CreatesNew() {
        this.centre_tmp.x = this.getWorldCentreX();
        this.centre_tmp.y = this.getWorldCentreY();
        return this.centre_tmp;
    }

    public MyPointF getWorldTopLeft_CreatesNew() {
        this.centre_tmp.x = this.getWorldX();
        this.centre_tmp.y = this.getWorldY();
        return this.centre_tmp;
    }
}

