/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.gui;

import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.gui.Button;

public class MultiLineButton
extends Node {
    private Paint paint;
    private Paint ink;
    private boolean word_wrap;
    private float width;
    protected StringBuffer str;
    private String cmd;
    private boolean padding;

    public MultiLineButton(String name, String _cmd, String text, Paint _paint, Paint _ink, boolean _word_wrap, float _width, boolean _padding) {
        super(name);
        this.paint = _paint;
        this.ink = _ink;
        this.word_wrap = _word_wrap;
        this.width = _width;
        this.padding = _padding;
        this.cmd = _cmd;
        this.str = new StringBuffer(text);
        this.showText();
    }

    protected void showText() {
        this.detachAllChildren();
        String text = this.str.toString();
        if (this.word_wrap) {
            int chars;
            ArrayList<String> al_lines = new ArrayList<String>();
            while (true) {
                int space_pos;
                chars = this.ink.breakText(text, this.width);
                int cr_pos = text.indexOf("\n");
                if (cr_pos >= 0 && cr_pos < chars) {
                    chars = cr_pos;
                }
                if (chars >= text.length()) break;
                if (!text.substring(chars, chars + 1).equalsIgnoreCase("\n") && (space_pos = text.substring(0, chars).lastIndexOf(" ")) >= 0) {
                    chars = space_pos;
                }
                al_lines.add(text.substring(0, chars));
                text = text.substring(chars + 1);
            }
            al_lines.add(text.substring(0, chars));
            this.showLines(al_lines);
        } else {
            String[] lines = text.split("\\n");
            ArrayList<String> al_lines = new ArrayList<String>();
            int i = 0;
            while (i < lines.length) {
                al_lines.add(lines[i]);
                ++i;
            }
            this.showLines(al_lines);
        }
    }

    private void showLines(ArrayList<String> lines) {
        if (this.padding) {
            lines.add("");
            lines.add(0, "");
        }
        this.removeAllChildren();
        int y = 0;
        for (String s : lines) {
            Button l = new Button(String.valueOf(this.name) + "_sublabel", this.cmd, s, 0.0f, y, this.width, this.ink.getTextSize() * 1.2f, this.paint, this.ink, null);
            this.attachChild(l);
            l.updateGeometricState();
            y = (int)((float)y + this.ink.getTextSize() * 1.2f);
        }
        this.updateGeometricState();
    }

    public void appendText(String s) {
        this.str.append(s);
        this.showText();
    }

    public void setText(String s) {
        this.str = new StringBuffer(s);
        this.showText();
    }

    public String getText() {
        return this.str.toString();
    }
}

