/*
 * Decompiled with CFR 0.152.
 */
package ssmith.astar;

import java.awt.Point;
import java.util.ArrayList;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.NumberFunctions;

public class WayPoints
extends ArrayList<Point> {
    private static final long serialVersionUID = 1L;

    public void insertRoute(int pos, WayPoints w) {
        this.addAll(pos, w);
    }

    public void truncate(int amt) {
        while (this.size() > amt) {
            this.remove(this.size() - 1);
        }
    }

    public void remove(int x, int y) {
        int i = 0;
        while (i < this.size()) {
            Point p = (Point)this.get(i);
            if (p.x == x && p.y == y) {
                this.remove(p);
            }
            ++i;
        }
    }

    public boolean contains(int x, int y) {
        int i = 0;
        while (i < this.size()) {
            Point p = (Point)this.get(i);
            if (p.x == x && p.y == y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Point getClosestPoint(int x, int y) {
        double closest_dist = Double.MAX_VALUE;
        int closest_point = -1;
        int p = 0;
        while (p < this.size()) {
            Point pnt = (Point)this.get(p);
            double dist = GeometryFuncs.distance(x, y, pnt.x, pnt.y);
            if (dist < closest_dist) {
                closest_dist = dist;
                closest_point = p;
            }
            ++p;
        }
        return (Point)this.get(closest_point);
    }

    public Point getNextPoint() {
        if (this.hasAnotherPoint()) {
            return (Point)this.get(0);
        }
        return null;
    }

    public Point getLastPoint() {
        return (Point)this.get(this.size() - 1);
    }

    public void removeCurrentPoint() {
        this.remove(0);
    }

    public boolean hasAnotherPoint() {
        return this.size() > 0;
    }

    public Point getRandomPoint() {
        return this.getRandomPoint(false);
    }

    public Point getRandomPoint(boolean remove) {
        if (this.hasAnotherPoint()) {
            int no = NumberFunctions.rnd(0, this.size() - 1);
            Point p = (Point)this.get(no);
            if (remove) {
                this.remove(no);
            }
            return p;
        }
        return null;
    }

    @Override
    public void add(int x, int y) {
        this.add(new Point(x, y));
    }

    @Override
    public void clear() {
        this.removeAll(this);
    }

    public WayPoints copy() {
        WayPoints w = new WayPoints();
        int i = 0;
        while (i < this.size()) {
            Point p = (Point)this.get(i);
            w.add(p);
            ++i;
        }
        return w;
    }
}

