/*
 * Decompiled with CFR 0.152.
 */
package ssmith.lang;

import java.util.Random;

public class NumberFunctions {
    private static Random random = new Random();

    public static int biggest(int a, int b) {
        return Math.max(a, b);
    }

    public static int rnd(int a, int b) {
        int var = b + 1 - a;
        return random.nextInt(var) + a;
    }

    public static byte rndByte(int a, int b) {
        assert (a <= 127 && b <= 127);
        int var = b + 1 - a;
        return (byte)(random.nextInt(var) + a);
    }

    public static short rndShort(int a, int b) {
        int var = b + 1 - a;
        return (short)(random.nextInt(var) + a);
    }

    public static float rndFloat(float a, float b) {
        return random.nextFloat() * (b - a) + a;
    }

    public static double rndDouble(double a, double b) {
        return random.nextDouble() * (b - a) + a;
    }

    public static int sign(int a) {
        if (a == 0) {
            return 0;
        }
        if (a > 0) {
            return 1;
        }
        return -1;
    }

    public static int sign(float a) {
        if (a == 0.0f) {
            return 0;
        }
        if (a > 0.0f) {
            return 1;
        }
        return -1;
    }

    public static int sign(double a) {
        if (a == 0.0) {
            return 0;
        }
        if (a > 0.0) {
            return 1;
        }
        return -1;
    }

    public static float MakeSameSignAs(float num, float s) {
        if (NumberFunctions.sign(num) != NumberFunctions.sign(s)) {
            return num * -1.0f;
        }
        return num;
    }

    public static int mod(int x) {
        if (x >= 0) {
            return x;
        }
        return x * -1;
    }

    public static float mod(float x) {
        if (x >= 0.0f) {
            return x;
        }
        return x * -1.0f;
    }

    public static double mod(double x) {
        if (x >= 0.0) {
            return x;
        }
        return x * -1.0;
    }

    public int remainder(int a, int d) {
        int r = (int)Math.IEEEremainder(a, d);
        if (r < 0) {
            r += d;
        }
        return r;
    }

    public static int ParseInt(String s) {
        return NumberFunctions.ParseInt(s, true);
    }

    public static int ParseInt(String s, boolean error) {
        try {
            if (s == null && !error) {
                s = "0";
            } else if (s.length() == 0) {
                s = "0";
            }
            s = s.trim();
            if (s.startsWith("+") && s.length() > 1) {
                s = s.substring(1);
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            if (error) {
                throw ex;
            }
            return 0;
        }
    }

    public static byte ParseByte(String s) {
        return NumberFunctions.ParseByte(s, true);
    }

    public static byte ParseByte(String s, boolean error) {
        try {
            if (s == null && !error) {
                s = "0";
            } else if (s.length() == 0) {
                s = "0";
            }
            return Byte.parseByte(s.trim());
        }
        catch (NumberFormatException ex) {
            if (error) {
                throw new NumberFormatException("Error parsing '" + s + "'");
            }
            return 0;
        }
    }

    public static short ParseShort(String s) {
        return NumberFunctions.ParseShort(s, true);
    }

    public static short ParseShort(String s, boolean error) {
        try {
            if (s == null && !error) {
                s = "0";
            } else if (s.length() == 0) {
                s = "0";
            }
            return Short.parseShort(s.trim());
        }
        catch (NumberFormatException ex) {
            if (error) {
                throw ex;
            }
            return 0;
        }
    }

    public static boolean IsNumeric(String s) {
        try {
            NumberFunctions.ParseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

