/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces;

import com.scs.stellarforces.MainWindow;
import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import dsr.comms.WGet_SF;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.io.IOFunctions;
import ssmith.lang.Functions;

public final class UpdateServerThread
extends Thread {
    private static String REQ_FILENAME;
    private static String REQ_FILENAME_EXTRA;
    private GameModule game;
    private volatile boolean processing = false;
    public volatile boolean stop_now = false;
    private ArrayList<String> reqs;
    private Object file_lock = new Object();
    private boolean use_file = false;
    private MainWindow window;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateServerThread(GameModule _game, MainWindow _window) {
        super("UpdateServer");
        this.game = _game;
        this.window = _window;
        if (this.file_lock == null) {
            this.file_lock = new Object();
        }
        Object object = this.file_lock;
        synchronized (object) {
            try {
                REQ_FILENAME = Statics.GetExtStorageDir() + "/" + "data_to_send.txt";
                REQ_FILENAME_EXTRA = Statics.GetExtStorageDir() + "/" + "data_to_send_extra.txt";
                File f = new File(REQ_FILENAME);
                if (f.exists()) {
                    this.use_file = true;
                } else {
                    IOFunctions.AppendLog(REQ_FILENAME, "", false);
                    IOFunctions.LoadText(REQ_FILENAME);
                    new File(REQ_FILENAME).delete();
                    this.use_file = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.use_file) {
            this.reqs = new ArrayList();
        }
        this.setDaemon(false);
        this.setProcessing(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(String s) {
        this.setProcessing(true);
        Object object = this.file_lock;
        synchronized (object) {
            if (this.use_file) {
                try {
                    IOFunctions.AppendLog(REQ_FILENAME_EXTRA, String.valueOf(s) + "~", false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.use_file = false;
                    this.reqs = new ArrayList();
                }
            } else {
                this.reqs.add(s);
            }
        }
    }

    public boolean isSendingData() {
        return this.processing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stop_now && this.window.isVisible() || this.isDataWaiting()) {
                if (this.isDataWaiting()) {
                    this.setProcessing(true);
                    while (this.isDataWaiting()) {
                        Object object;
                        StringBuffer data = new StringBuffer();
                        if (this.use_file) {
                            object = this.file_lock;
                            synchronized (object) {
                                if (!new File(REQ_FILENAME).exists()) {
                                    String tmp = IOFunctions.LoadText(REQ_FILENAME_EXTRA);
                                    IOFunctions.AppendLog(REQ_FILENAME, tmp, false);
                                    new File(REQ_FILENAME_EXTRA).delete();
                                }
                                data.append(IOFunctions.LoadText(REQ_FILENAME));
                            }
                        }
                        object = this.file_lock;
                        synchronized (object) {
                            int i = 0;
                            while (i < this.reqs.size()) {
                                data.append(String.valueOf(this.reqs.get(i)) + "~");
                                ++i;
                            }
                            this.reqs.clear();
                        }
                        this.sendData(data.toString());
                        if (!this.use_file) continue;
                        new File(REQ_FILENAME).delete();
                    }
                }
                this.setProcessing(false);
                Functions.delay(1000);
            }
            System.out.println("Finished");
        }
        catch (IOException ex) {
            AbstractActivity act = Statics.act;
            this.processing = false;
            this.game.addToHUD("* " + act.getString("restart_client") + " *");
            this.game.stopGameDueToError();
        }
        catch (Exception ex) {
            AbstractActivity act = Statics.act;
            this.processing = false;
            AbstractActivity.HandleError(ex);
            this.game.addToHUD("* " + act.getString("restart_client") + " *");
            this.game.stopGameDueToError();
        }
        Statics.p("UpdateServerThread ended.");
    }

    private void setProcessing(boolean p) {
        this.processing = p;
    }

    private void sendData(String post_data) throws UnknownHostException, IOException {
        AbstractActivity act = Statics.act;
        WGet_SF wc = new WGet_SF(act, this.game, post_data);
        String tmp_response = wc.getResponse();
        String[] responses = tmp_response.split("~", -1);
        int i = 0;
        while (i < responses.length) {
            String response = responses[i];
            if (!response.equalsIgnoreCase("ok")) {
                if (response.equalsIgnoreCase("draw")) {
                    this.game.gameIsDraw();
                } else if (response.equalsIgnoreCase("s1w")) {
                    this.game.sideHasWon((byte)1);
                } else if (response.equalsIgnoreCase("s2w")) {
                    this.game.sideHasWon((byte)2);
                } else if (response.equalsIgnoreCase("s3w")) {
                    this.game.sideHasWon((byte)3);
                } else if (response.equalsIgnoreCase("s4w")) {
                    this.game.sideHasWon((byte)4);
                } else if (response.toLowerCase().startsWith("msg")) {
                    this.game.addToHUD(response.substring("msg".length()));
                } else {
                    if (this.game != null) {
                        this.game.addToHUD(String.valueOf(act.getString("unexpected_response")) + ":");
                        this.game.addToHUD("'" + response + "'");
                        this.game.addToHUD("* " + act.getString("restart_client") + " *");
                        this.game.stopGameDueToError();
                    }
                    this.processing = false;
                }
            }
            ++i;
        }
    }

    private boolean isDataWaiting() {
        if (this.use_file) {
            return new File(REQ_FILENAME).exists() || new File(REQ_FILENAME_EXTRA).exists();
        }
        return this.reqs.size() > 0;
    }
}

