/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import dsr.comms.DataTable;
import dsr.data.EquipmentData;
import dsr.data.MapSquare;
import dsr.data.UnitData;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.RectF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractSingleScreenModule;
import ssmith.util.Interval;
import ssmith.util.PointByte;

public class ScannerModule
extends AbstractSingleScreenModule {
    public static final String SCANNER_COORDS = "Scanner_Coords";
    private static final String SCANNER_TITLE = "Strategic Scanner";
    private static final String SCANNER_MSG = "Press the scanner to view that area";
    private static Paint paint_title_text = new Paint();
    private static Paint paint_small_text = new Paint();
    private static Paint walls_simple = new Paint();
    private static Paint walls_blur = new Paint();
    private static Paint paint_walls = new Paint();
    private static Paint paint_destroyed_cpu = new Paint();
    private static Paint paint_cpu = new Paint();
    private static Paint paint_installation = new Paint();
    private static Paint paint_comrades = new Paint();
    private static Paint paint_eggs = new Paint();
    private static Paint paint_our_units = new Paint();
    private static Paint paint_enemy = new Paint();
    private static Paint white = new Paint();
    private static Paint paint_door = new Paint();
    private static Paint paint_black = new Paint();
    private static Paint paint_heard_move_enemy = new Paint();
    private static Paint paint_heard_shooting_enemy = new Paint();
    private static Paint paint_seen_enemy = new Paint();
    private ArrayList<Point> eggs;
    private float sq_size;
    private float offset_x;
    private float offset_y;
    private GameModule game;
    private RectF tmp_rect = new RectF();
    private boolean draw_units = true;
    private Interval unit_flash = new Interval(500L);
    private float draw_upto_x;
    private float draw_upto_y;

    static {
        paint_destroyed_cpu.setARGB(255, 50, 50, 100);
        paint_cpu.setARGB(255, 50, 50, 255);
        paint_installation.setARGB(255, 150, 50, 55);
        paint_comrades.setARGB(255, 155, 100, 155);
        paint_eggs.setARGB(255, 0, 255, 0);
        paint_our_units.setARGB(255, 255, 0, 255);
        paint_enemy.setARGB(255, 255, 0, 0);
        white.setARGB(255, 255, 255, 255);
        paint_door.setARGB(255, 152, 80, 50);
        paint_door.setARGB(255, 0, 0, 0);
        paint_title_text.setARGB(155, 255, 255, 255);
        paint_title_text.setAntiAlias(true);
        paint_small_text.setARGB(200, 255, 255, 255);
        paint_small_text.setAntiAlias(true);
        paint_heard_move_enemy.setARGB(255, 150, 150, 150);
        paint_heard_shooting_enemy.setARGB(255, 255, 255, 255);
        paint_seen_enemy.setARGB(255, 150, 0, 0);
    }

    public ScannerModule(AbstractActivity act, GameModule _return_to) {
        super(-1);
        paint_title_text.setTypeface(Statics.bigfnt);
        paint_small_text.setTypeface(Statics.stdfnt);
        act.playSound("scanner");
        paint_walls.setARGB(255, 0, 180, 0);
        this.mod_return_to = _return_to;
        this.game = _return_to;
        this.eggs = new ArrayList();
        int i = 0;
        while (i < this.game.equipment.length) {
            block4: {
                int y;
                int x;
                block6: {
                    EquipmentData eq;
                    block5: {
                        eq = this.game.equipment[i];
                        if (eq.destroyed || eq.major_type != 13 && eq.major_type != 12) break block4;
                        x = -1;
                        y = -1;
                        if (eq.getUnitID() <= 0) break block5;
                        UnitData unit = UnitData.GetUnitDataFromID(this.game.units, eq.getUnitID());
                        x = unit.getMapX();
                        y = unit.getMapY();
                        break block6;
                    }
                    PointByte p = EquipmentData.GetEquipmentMapSquare(this.game.mapdata, eq);
                    if (p == null) break block4;
                    x = p.x;
                    y = p.y;
                }
                this.eggs.add(new Point(x, y));
            }
            ++i;
        }
        this.sq_size = Statics.SCREEN_HEIGHT / this.game.mapdata.getMapHeight();
        this.offset_x = ((float)Statics.SCREEN_WIDTH - (float)this.game.mapdata.getMapWidth() * this.sq_size) / 2.0f;
        this.offset_y = ((float)Statics.SCREEN_HEIGHT - (float)this.game.mapdata.getMapHeight() * this.sq_size) / 2.0f;
        this.createPaints();
        DataTable heard_enemies = this.game.game_data.heard_enemies;
        UnitData[] units = this.game.units;
        heard_enemies.moveBeforeFirst();
        while (heard_enemies.moveNext()) {
            UnitData unit = UnitData.GetUnitDataFromID(units, heard_enemies.getInt("UnitID"));
            if (unit.getStatus() == 2) continue;
            heard_enemies.removeCurrentRow();
            heard_enemies.movePrev();
        }
    }

    private void createPaints() {
        walls_simple = new Paint();
        walls_simple.setAntiAlias(true);
        walls_simple.setColor(new Color(155, 255, 55, 200));
        walls_simple.setStrokeWidth(this.sq_size);
        walls_blur = new Paint();
        walls_blur.setColor(new Color(74, 255, 155, 100));
        walls_blur.setStrokeWidth(this.sq_size * 1.4f);
    }

    @Override
    public void started() {
        this.draw_upto_x = 0.0f;
        this.draw_upto_y = 0.0f;
    }

    @Override
    public void doDraw(Canvas g, long interpol) {
        if (this.draw_upto_x <= (float)Statics.SCREEN_WIDTH) {
            this.draw_upto_x += (float)Statics.SCREEN_WIDTH / 10.0f;
        }
        if (this.draw_upto_y <= (float)Statics.SCREEN_HEIGHT) {
            this.draw_upto_y += (float)Statics.SCREEN_HEIGHT / 10.0f;
        }
        if (this.unit_flash.hitInterval()) {
            this.draw_units = !this.draw_units;
        }
        g.drawText(SCANNER_TITLE, 10.0f, paint_title_text.getTextSize(), paint_title_text);
        g.drawText(SCANNER_MSG, 10.0f, (float)Statics.SCREEN_HEIGHT - paint_small_text.getTextSize() * 1.1f, paint_small_text);
        g.drawLine(this.draw_upto_x, 0.0f, this.draw_upto_x, Statics.SCREEN_HEIGHT, walls_simple);
        g.drawLine(this.draw_upto_x, 0.0f, this.draw_upto_x, Statics.SCREEN_HEIGHT, walls_blur);
        g.drawLine(0.0f, this.draw_upto_y, Statics.SCREEN_WIDTH, this.draw_upto_y, walls_simple);
        g.drawLine(0.0f, this.draw_upto_y, Statics.SCREEN_WIDTH, this.draw_upto_y, walls_blur);
        g.translate(this.offset_x, this.offset_y);
        int y2 = 0;
        while (y2 < this.game.mapdata.getMapHeight()) {
            int x2 = 0;
            while (x2 < this.game.mapdata.getMapWidth()) {
                MapSquare sq = this.game.mapdata.getSq_MaybeNULL(x2, y2);
                this.tmp_rect.set((float)x2 * this.sq_size, (float)y2 * this.sq_size, (float)x2 * this.sq_size + this.sq_size, (float)y2 * this.sq_size + this.sq_size);
                if (!(this.tmp_rect.left > this.draw_upto_x) && !(this.tmp_rect.top > this.draw_upto_y)) {
                    if (sq.escape_hatch_side > 0) {
                        g.drawRect(this.tmp_rect, white);
                    } else if (this.game.game_data.game_status == 20 && this.game.game_data.areSidesFriends(sq.deploy_sq_side, this.game.game_data.our_side) && sq.major_type == 1) {
                        g.drawRect(this.tmp_rect, paint_enemy);
                    } else if (sq.major_type == 2) {
                        if (sq.destroyed == 0) {
                            g.drawRect(this.tmp_rect, paint_cpu);
                        } else {
                            g.drawRect(this.tmp_rect, paint_destroyed_cpu);
                        }
                    } else if (sq.major_type == 3) {
                        g.drawRect(this.tmp_rect, paint_walls);
                        float d = 2.0f;
                        g.drawRect(this.tmp_rect.left - d, this.tmp_rect.top - d, this.tmp_rect.right + d, this.tmp_rect.bottom + d, walls_blur);
                    } else if (sq.major_type == 1) {
                        if (sq.texture_code == 11) {
                            g.drawRect(this.tmp_rect, paint_cpu);
                        } else if (sq.texture_code == 86 || sq.texture_code == 87 || sq.texture_code == 88 || sq.texture_code == 85 || sq.texture_code == 84 || sq.texture_code == 93) {
                            g.drawRect(this.tmp_rect, paint_installation);
                        } else if (sq.door_type > 0 && !sq.door_open) {
                            g.drawRect(this.tmp_rect, paint_door);
                        }
                    } else if (sq.major_type == 0) {
                        g.drawRect(this.tmp_rect, paint_walls);
                    }
                }
                ++x2;
            }
            ++y2;
        }
        if (this.draw_units) {
            DataTable heard_enemies = this.game.game_data.heard_enemies;
            heard_enemies.moveBeforeFirst();
            while (heard_enemies.moveNext()) {
                this.tmp_rect.set((float)heard_enemies.getInt("MapX") * this.sq_size, (float)heard_enemies.getInt("MapY") * this.sq_size, (float)heard_enemies.getInt("MapX") * this.sq_size + this.sq_size, (float)heard_enemies.getInt("MapY") * this.sq_size + this.sq_size);
                if (heard_enemies.getInt("VisibleType") == 1) {
                    g.drawOval(this.tmp_rect, paint_heard_move_enemy);
                    continue;
                }
                g.drawOval(this.tmp_rect, paint_heard_shooting_enemy);
            }
            DataTable seen_enemies = this.game.game_data.seen_enemies;
            seen_enemies.moveBeforeFirst();
            while (seen_enemies.moveNext()) {
                this.tmp_rect.set((float)seen_enemies.getInt("MapX") * this.sq_size, (float)seen_enemies.getInt("MapY") * this.sq_size, (float)seen_enemies.getInt("MapX") * this.sq_size + this.sq_size, (float)seen_enemies.getInt("MapY") * this.sq_size + this.sq_size);
                g.drawOval(this.tmp_rect, paint_seen_enemy);
            }
        }
        for (Point p : this.eggs) {
            this.tmp_rect.set((float)p.x * this.sq_size, (float)p.y * this.sq_size, (float)p.x * this.sq_size + this.sq_size, (float)p.y * this.sq_size + this.sq_size);
            g.drawOval(this.tmp_rect, paint_eggs);
        }
        if (this.draw_units) {
            int i = 0;
            while (i < this.game.units.length) {
                UnitData unit = this.game.units[i];
                if (unit.getStatus() == 2) {
                    this.tmp_rect.set((float)unit.map_x * this.sq_size, (float)unit.map_y * this.sq_size, (float)unit.map_x * this.sq_size + this.sq_size, (float)unit.map_y * this.sq_size + this.sq_size);
                    if (this.game.game_data.areSidesFriends(unit.getSide(), this.game.game_data.our_side)) {
                        if (unit == this.game.getCurrentUnit()) {
                            g.drawOval(this.tmp_rect, white);
                        } else if (unit.getSide() == this.game.game_data.our_side) {
                            g.drawOval(this.tmp_rect, paint_our_units);
                        } else {
                            g.drawOval(this.tmp_rect, paint_comrades);
                        }
                        if (unit.unit_type == 1) {
                            float inset = this.sq_size / 4.0f;
                            this.tmp_rect.set((float)unit.map_x * this.sq_size + inset, (float)unit.map_y * this.sq_size + inset, (float)unit.map_x * this.sq_size + this.sq_size - inset, (float)unit.map_y * this.sq_size + this.sq_size - inset);
                            g.drawOval(this.tmp_rect, paint_black);
                        }
                    } else if (unit.model != null && unit.model.visible) {
                        g.drawOval(this.tmp_rect, paint_enemy);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean processEvent(MyEvent evt) throws Exception {
        float x = evt.getX() - this.offset_x;
        float y = evt.getY() - this.offset_y;
        int sx = (int)(x / this.sq_size);
        int sy = (int)(y / this.sq_size);
        Statics.data.clear();
        if (sx >= 0 && sx < this.game.mapdata.getMapWidth() && sy >= 0 && sy < this.game.mapdata.getMapHeight()) {
            Statics.data.put(SCANNER_COORDS, String.valueOf(sx) + "," + sy);
        }
        return super.processEvent(evt);
    }

    @Override
    public boolean playMusic() {
        return false;
    }
}

