/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game.ai;

import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.ai.AbstractAI;
import dsr.data.MapSquare;
import dsr.data.UnitData;
import ssmith.lang.NumberFunctions;

public class SimpleRotateAI
extends AbstractAI {
    private int num_rotations;

    public SimpleRotateAI(UnitData unit) {
        super(unit);
    }

    @Override
    public boolean process(GameModule game) {
        boolean facing_wall = false;
        boolean facing_door = false;
        MapSquare sq = this.unit.model.getSquareInFrontOfUnit_MaybeNULL();
        if (sq != null) {
            if (sq.major_type == 3 || sq.major_type == 2) {
                facing_wall = true;
            } else if (sq.door_type > 0) {
                facing_door = true;
            }
        }
        if (super.getSeenEnemy(game) == null) {
            if (!facing_wall) {
                if (this.unit.getAPs() <= this.unit.opp_fire_aps_req + 6) {
                    return false;
                }
                if (this.num_rotations > NumberFunctions.rnd(10, 16)) {
                    return false;
                }
                if (!facing_door || this.num_rotations == 0) {
                    this.unit.turnBy(45);
                    ++this.num_rotations;
                    return true;
                }
                return false;
            }
            this.unit.turnBy(45);
            ++this.num_rotations;
            return true;
        }
        if (this.unit.getAPs() >= this.getShotAPs()) {
            super.shootAtEnemyEnemies(game);
            return true;
        }
        return false;
    }
}

