/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.AbstractCorpse;
import com.scs.stellarforces.graphics.GameObject;
import com.scs.stellarforces.graphics.GasCannister;
import dsr.data.EquipmentData;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;

public class EquipmentModel
extends GameObject {
    protected BufferedImage bmp;

    public static GameObject Factory(GameModule game, EquipmentData eq, int map_x, int map_y) {
        String equipcode = eq.code;
        switch (eq.major_type) {
            case 14: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "corpse1");
            }
            case 15: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "corpse2");
            }
            case 16: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "corpse3");
            }
            case 17: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "corpse4");
            }
            case 18: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "sterner_corpse");
            }
            case 19: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "alien_corpse");
            }
            case 20: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "alien_corpse");
            }
            case 26: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "alien_corpse");
            }
            case 27: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "alien_corpse");
            }
            case 28: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "alien_corpse");
            }
            case 29: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "zombie_corpse");
            }
            case 30: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "clone1_corpse");
            }
            case 31: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "clone2_corpse");
            }
            case 32: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "clone3_corpse");
            }
            case 33: {
                return new AbstractCorpse(game, eq.getName(false), map_x, map_y, "clone4_corpse");
            }
            case 13: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "alien_egg");
            }
            case 2: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "grenade");
            }
            case 21: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "smoke_grenade");
            }
            case 22: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "nerve_gas_grenade");
            }
            case 9: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "death_grenade");
            }
            case 23: {
                return new GasCannister(game, eq, map_x, map_y);
            }
            case 1: {
                if (equipcode.equalsIgnoreCase("SP30")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "sp30");
                }
                if (equipcode.equalsIgnoreCase("rocket_launcher")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "rocket_launcher");
                }
                if (equipcode.equalsIgnoreCase("marsecautogun")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "ms_autogun");
                }
                if (equipcode.equalsIgnoreCase("heavylaser")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "heavy_laser");
                }
                if (equipcode.indexOf("lasrifle") >= 0) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "las_rifle");
                }
                if (equipcode.equalsIgnoreCase("m4000")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "m4000");
                }
                if (equipcode.equalsIgnoreCase("marsecpistol")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "marsec_pistol");
                }
                if (equipcode.equalsIgnoreCase("l50")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "l50");
                }
                if (equipcode.equalsIgnoreCase("mk1")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "mk1");
                }
                if (equipcode.equalsIgnoreCase("sniperrifle")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "sniper_rifle");
                }
                if (equipcode.equalsIgnoreCase("autocannon")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "autocannon");
                }
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "rifle");
            }
            case 3: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "medikit");
            }
            case 4: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "knife");
            }
            case 25: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "scanner");
            }
            case 12: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "flag");
            }
            case 5: {
                if (equipcode.equalsIgnoreCase("rocket")) {
                    return new EquipmentModel(game, eq.getName(false), map_x, map_y, "rocket");
                }
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "ammo_clip");
            }
            case 34: {
                return new EquipmentModel(game, eq.getName(false), map_x, map_y, "incendiary_grenade");
            }
        }
        return new EquipmentModel(game, eq.getName(false), map_x, map_y, "crate");
    }

    public EquipmentModel(GameModule _game, String name, float map_x, float map_y, String img) {
        super(_game, name, true, map_x * Statics.SQ_SIZE, map_y * Statics.SQ_SIZE, Statics.SQ_SIZE, Statics.SQ_SIZE, false, false);
        this.bmp = Statics.img_cache.getImage(img, Statics.SQ_SIZE * 0.7f, Statics.SQ_SIZE * 0.7f);
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            g.drawImage(this.bmp, this.world_bounds.left - cam.left + Statics.SQ_SIZE / 4.0f, this.world_bounds.top - cam.top + Statics.SQ_SIZE / 4.0f, this.paint);
        }
    }
}

