/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.units.AbstractUnit;
import com.scs.stellarforces.graphics.units.Alien;
import com.scs.stellarforces.graphics.units.AlienQueen;
import com.scs.stellarforces.graphics.units.Blob;
import ssmith.android.lib2d.MyPickResults;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.Ray;
import ssmith.android.lib2d.shapes.AbstractRectangle;
import ssmith.lang.GeometryFuncs;

public abstract class GameObject
extends AbstractRectangle {
    protected GameModule game;
    public boolean can_be_shot;
    public boolean blocks_view;

    public GameObject(GameModule _game, String name, boolean _collides, float pxl_x, float pxl_y, float w, float h, boolean _can_be_shot, boolean _blocks_view) {
        super(name, null, pxl_x, pxl_y, w, h);
        this.game = _game;
        this.collides = _collides;
        this.can_be_shot = _can_be_shot;
        this.blocks_view = _blocks_view;
    }

    public float getMapDistTo(GameObject go) {
        return this.getMapDistTo((int)(go.getWorldX() / Statics.SQ_SIZE), (int)(go.getWorldY() / Statics.SQ_SIZE));
    }

    public float getMapDistTo(int map_x, int map_y) {
        return GeometryFuncs.distance(this.getWorldX(), this.getWorldY(), (float)map_x * Statics.SQ_SIZE, (float)map_y * Statics.SQ_SIZE) / Statics.SQ_SIZE;
    }

    public boolean canSee(GameObject other, int ang_or_minus_one, boolean do_units_block) {
        return this.canSee(other, ang_or_minus_one, do_units_block, 0, false, false);
    }

    public boolean canSee(GameObject other, int ang_or_minus_one, boolean do_units_block, int max_block_count) {
        return this.canSee(other, ang_or_minus_one, do_units_block, max_block_count, false, false);
    }

    public boolean canSee(GameObject other, int ang_or_minus_one, boolean do_units_block, int max_block_count, boolean ignore_smoke, boolean ignore_cpu) {
        return this.getCanSeeCount(other, ang_or_minus_one, do_units_block, 0, ignore_smoke, ignore_cpu) == 0;
    }

    public int getCanSeeCount(GameObject other, int ang_or_minus_one, boolean do_units_block, int max_block_count, boolean ignore_smoke, boolean ignore_cpu) {
        int CANNOT_SEE = 999;
        int CAN_SEE = 0;
        float dist = this.getDistanceTo(other);
        if (dist <= Statics.SQ_SIZE * 0.6f) {
            return CAN_SEE;
        }
        if (ang_or_minus_one >= 0 && !(this instanceof Blob)) {
            int ang_to_target = this.getAbsoluteAngleTo(other.getWorldCentreX(), other.getWorldCentreY());
            float diff = GeometryFuncs.GetDiffBetweenAngles(ang_or_minus_one, ang_to_target);
            int field_of_vision = 49;
            if (this instanceof Alien || this instanceof AlienQueen) {
                field_of_vision *= 2;
            }
            if (diff > (float)field_of_vision) {
                return CANNOT_SEE;
            }
        }
        if (dist <= Statics.SQ_SIZE * 1.6f) {
            return CAN_SEE;
        }
        int block_count = 0;
        MyPointF dir = other.getWorldCentre_CreatesNew().subtract(this.getWorldCentre_CreatesNew());
        dir.normalizeLocal();
        Ray r = new Ray(this.getWorldCentre_CreatesNew().multiply(1.0f), dir);
        MyPickResults can_see_results = new MyPickResults(this, other);
        this.game.root_node.findPick(r, can_see_results);
        this.game.mapdata.canSee(r, can_see_results, ignore_smoke, ignore_cpu);
        can_see_results.sort();
        if (can_see_results.getNumber() > 0) {
            int i = 0;
            while (i < can_see_results.getNumber()) {
                GameObject obj = can_see_results.getGameObject(i);
                if (obj == other) {
                    return block_count;
                }
                if (obj.blocks_view && (!(obj instanceof AbstractUnit) || do_units_block)) {
                    ++block_count;
                    if (--max_block_count < 0) {
                        return block_count;
                    }
                }
                ++i;
            }
        }
        return block_count;
    }

    public int getExplosionWallProtectionCount(int s_mapx, int s_mapy) {
        float dist = this.getMapDistTo(s_mapx, s_mapy);
        if (dist <= 1.5f) {
            return 0;
        }
        int ex = (int)(this.getWorldCentre_CreatesNew().x / Statics.SQ_SIZE);
        int ey = (int)(this.getWorldCentre_CreatesNew().y / Statics.SQ_SIZE);
        return this.game.mapdata.getBlockCountInLOS_Pixels_Centre(s_mapx, s_mapy, ex, ey, true, true);
    }

    public float getDistanceTo(GameObject other) {
        return GeometryFuncs.distance(this.getWorldCentreX(), this.getWorldCentreY(), other.getWorldCentreX(), other.getWorldCentreY());
    }

    public int getAbsoluteAngleTo(float x, float y) {
        int x2 = (int)(x - this.getWorldCentreX());
        int y2 = (int)(y - this.getWorldCentreY());
        return (int)Math.toDegrees(Math.atan2(y2, x2));
    }

    public boolean isChanceofNotHitting() {
        return this.getChanceofNotHitting() > 0;
    }

    public int getChanceofNotHitting() {
        return 0;
    }
}

