/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics.units;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.EnemyHighlighter;
import com.scs.stellarforces.graphics.GameObject;
import com.scs.stellarforces.graphics.units.Alien;
import com.scs.stellarforces.graphics.units.AlienQueen;
import com.scs.stellarforces.graphics.units.Angel;
import com.scs.stellarforces.graphics.units.Blob;
import com.scs.stellarforces.graphics.units.Clone;
import com.scs.stellarforces.graphics.units.Crab;
import com.scs.stellarforces.graphics.units.Ghoul;
import com.scs.stellarforces.graphics.units.GhoulQueen;
import com.scs.stellarforces.graphics.units.HumanUnit;
import com.scs.stellarforces.graphics.units.Zombie;
import dsr.data.EquipmentData;
import dsr.data.MapSquare;
import dsr.data.UnitData;
import java.awt.Point;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.MyPointF;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.NumberFunctions;
import ssmith.util.PointByte;

public abstract class AbstractUnit
extends GameObject
implements IProcessable {
    private static Paint paint_unit_name = new Paint();
    public BufferedImage[] bmps = new BufferedImage[8];
    public BufferedImage current_bmp = null;
    public UnitData unit_data;
    public static BufferedImage[] unit_highlighters = new BufferedImage[8];
    protected static final float UNIT_IMAGE_SIZE = Statics.SQ_SIZE * 1.2f;
    protected static final float SIZE_DIFF = UNIT_IMAGE_SIZE - Statics.SQ_SIZE;
    protected float centre_offset = 0.0f;
    private EnemyHighlighter enemy_highlighter;
    private static BufferedImage bmp_on_fire;
    private static Point tmp;

    static {
        paint_unit_name.setARGB(255, 255, 255, 255);
        paint_unit_name.setAntiAlias(true);
        paint_unit_name.setTextSize((float)Statics.SCREEN_HEIGHT * 0.04f);
        paint_unit_name.setTypeface(Statics.stdfnt);
        tmp = new Point(0, 0);
    }

    public static AbstractUnit Factory(GameModule game, UnitData unit) {
        if (unit_highlighters[0] == null) {
            AbstractUnit.unit_highlighters[0] = GameModule.ImgCache.getImage("unit_highlighter_e", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[1] = GameModule.ImgCache.getImage("unit_highlighter_se", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[2] = GameModule.ImgCache.getImage("unit_highlighter_s", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[3] = GameModule.ImgCache.getImage("unit_highlighter_sw", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[4] = GameModule.ImgCache.getImage("unit_highlighter_w", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[5] = GameModule.ImgCache.getImage("unit_highlighter_nw", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[6] = GameModule.ImgCache.getImage("unit_highlighter_n", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            AbstractUnit.unit_highlighters[7] = GameModule.ImgCache.getImage("unit_highlighter_ne", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
            bmp_on_fire = GameModule.ImgCache.getImage("fire", UNIT_IMAGE_SIZE, UNIT_IMAGE_SIZE);
        }
        switch (unit.model_type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return new HumanUnit(game, unit);
            }
            case 7: {
                return new AlienQueen(game, unit);
            }
            case 3: {
                return new Alien(game, unit);
            }
            case 8: {
                return new Blob(game, unit);
            }
            case 9: {
                return new Crab(game, unit);
            }
            case 10: {
                return new Ghoul(game, unit);
            }
            case 11: {
                return new GhoulQueen(game, unit);
            }
            case 12: {
                return new Zombie(game, unit);
            }
            case 13: {
                return new Clone(game, unit);
            }
            case 14: {
                return new Angel(game, unit);
            }
        }
        throw new RuntimeException("Unknown model type: " + unit.model_type + ".  You need to update your client!");
    }

    protected AbstractUnit(GameModule _game, UnitData _unit, float x, float y) {
        super(_game, _unit.name, true, x, y, Statics.SQ_SIZE * 0.9f, Statics.SQ_SIZE * 0.9f, true, true);
        this.unit_data = _unit;
    }

    public void moveFwd() {
        Point p = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle());
        this.move(p, 1.0f);
    }

    public void moveBack() {
        Point p = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle() + 180);
        this.move(p, 2.0f);
    }

    public void moveStrafeLeft() {
        Point p = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle() - 90);
        this.move(p, 1.5f);
    }

    public void moveStrafeRight() {
        Point p = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle() + 90);
        this.move(p, 1.5f);
    }

    public void turnBy(int ang) {
        boolean no_aps;
        this.game.root_cam.lookAt(this, false);
        boolean bl = no_aps = this.unit_data.model_type == 8;
        if (no_aps || this.unit_data.checkAndReduceAPs(this.game, 1)) {
            this.unit_data.turnBy(ang);
            this.game.updateUnitOnServer(this.unit_data);
            boolean[] who_can_see = this.game.whichSidesCanSeeUnit(this.unit_data);
            this.game.sendEventToServer_UnitMoved(this.unit_data, who_can_see);
            this.game.recalcVisibleEnemiesAndOppFire(true, this.unit_data);
            this.game.updateMenu();
            if (Statics.USE_NEW_MOVEMENT_ICONS == 1) {
                this.game.hud.new_movement.updateMovementIcons(this.unit_data);
            }
        }
    }

    public void anim_walk() {
    }

    public void anim_standStill() {
    }

    public MapSquare getSquareInFrontOfUnit_MaybeNULL() {
        Point offset = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle());
        Point new_pos = new Point(this.unit_data.getMapX() + offset.x, this.unit_data.getMapY() + offset.y);
        MapSquare sq = this.game.mapdata.getSq_MaybeNULL(new_pos.x, new_pos.y);
        return sq;
    }

    public UnitData getUnitInFrontOfUnit_MaybeNULL() {
        Point offset = AbstractUnit.GetDirFromAngle(this.unit_data.getAngle());
        Point new_pos = new Point(this.unit_data.getMapX() + offset.x, this.unit_data.getMapY() + offset.y);
        UnitData unit = this.game.getUnitAt(new_pos.x, new_pos.y);
        return unit;
    }

    public MapSquare getSquare_MaybeNULL() {
        MapSquare sq = this.game.mapdata.getSq_MaybeNULL(this.unit_data.getMapX(), this.unit_data.getMapY());
        return sq;
    }

    private void move(Point offset, float ap_mult) {
        this.move(offset, ap_mult, false);
    }

    private void move(Point offset, float ap_mult, boolean stairs) {
        AbstractActivity act = Statics.act;
        this.game.root_cam.lookAt(this, false);
        if (!this.game.isObjectUpdating(this)) {
            PointByte new_pos = new PointByte(this.unit_data.getMapX() + offset.x, this.unit_data.getMapY() + offset.y);
            MapSquare sq = this.game.mapdata.getSq_MaybeNULL(new_pos.x, new_pos.y);
            if (sq != null) {
                boolean can_walk;
                if (sq.texture_code == 11 && this.unit_data.on_fire == 1) {
                    this.unit_data.on_fire = 0;
                    this.game.updateUnitOnServer(this.unit_data);
                }
                if (!(can_walk = sq.isTraversable())) {
                    boolean bl = can_walk = can_walk || sq.major_type == 3 && sq.texture_code == 50 && this.game.game_data.mission_type == 62;
                    if (can_walk) {
                        ap_mult *= 2.0f;
                    }
                }
                if (can_walk) {
                    byte ap_cost = this.getAPCostToWalk(ap_mult, sq);
                    UnitData opponent = this.game.getUnitAt(new_pos.x, new_pos.y);
                    if (opponent != null) {
                        ap_cost = (byte)(ap_cost * 2);
                    }
                    if (stairs || this.unit_data.checkAndReduceAPs(this.game, ap_cost)) {
                        if (opponent == null) {
                            if (!(stairs || sq.texture_code != 82 && sq.texture_code != 83)) {
                                if ((sq = this.game.findEndStairsSquare(sq)) != null) {
                                    this.move(new Point(sq.x - this.unit_data.map_x, sq.y - this.unit_data.map_y), ap_mult, true);
                                }
                            } else {
                                this.unit_data.setTargetMapLocation(this.game, new_pos.x, new_pos.y, sq);
                            }
                            if (this.unit_data.model_type == 8) {
                                act.playSound("blobmove");
                            } else {
                                act.playSound("footstep.wav");
                            }
                            boolean[] who_can_see = this.game.whichSidesCanSeeUnit(this.unit_data);
                            this.game.sendEventToServer_UnitMoved(this.unit_data, who_can_see);
                        } else {
                            boolean snafu_blocked;
                            boolean bl = snafu_blocked = this.game.game_data.is_snafu == 1 && this.game.game_data.snafu_will_opp_fire_on_side[opponent.getSide()] == 0;
                            if (this.game.game_data.areSidesFriends(opponent.getSide(), this.unit_data.getSide()) || snafu_blocked) {
                                if (this.game.game_data.areSidesFriends(opponent.getSide(), this.unit_data.getSide())) {
                                    if (this.unit_data.model_type == 8 && opponent.model_type == 8) {
                                        this.unit_data.incHealth(opponent.getHealth(), true);
                                        this.unit_data.combat_skill += opponent.combat_skill;
                                        this.unit_data.strength += opponent.strength;
                                        this.game.updateUnitOnServer(this.unit_data);
                                        opponent.damage(this.game, opponent.getHealth(), this.unit_data, 6);
                                        return;
                                    }
                                    this.game.addToHUD(String.valueOf(opponent.name) + " is in the way.");
                                } else if (snafu_blocked) {
                                    this.game.addToHUD(String.valueOf(opponent.name) + " is not set as an enemy.");
                                }
                                this.unit_data.incAPs(ap_cost);
                            } else {
                                this.game.closeCombat(this.unit_data, opponent);
                            }
                        }
                    }
                } else if (sq.major_type == 2) {
                    if (sq.destroyed == 0) {
                        if (!this.game.game_data.areSidesFriends(sq.owner_side, this.unit_data.getSide())) {
                            int ap_cost = this.getAPCostToWalk(ap_mult, sq) * 3;
                            if (this.unit_data.checkAndReduceAPs(this.game, ap_cost)) {
                                int rnd;
                                int str = this.unit_data.strength;
                                if (this.unit_data.current_item != null) {
                                    str += this.unit_data.current_item.cc_damage;
                                }
                                if ((rnd = NumberFunctions.rnd(1, str)) >= 5) {
                                    this.game.computerDestroyed(sq, this.unit_data);
                                } else {
                                    this.game.addToHUD("Computer not destroyed.");
                                }
                            }
                        } else {
                            this.game.addToHUD("That is your computer!");
                        }
                    } else {
                        this.game.addToHUD("The computer is already destroyed!");
                    }
                } else {
                    act.playSound("bump1.wav");
                }
                this.game.updateUnitOnServer(this.unit_data);
            }
        }
    }

    private byte getAPCostToWalk(float mult, MapSquare sq) {
        byte ap_cost = 6;
        if (this.unit_data.getAngle() % 90 == 0) {
            ap_cost = 4;
        }
        if (sq.door_type > 0 && !sq.door_open) {
            ap_cost = (byte)(ap_cost * 2);
        }
        ap_cost = (byte)((float)ap_cost * mult);
        return ap_cost;
    }

    public static Point GetDirFromAngle(int ang_deg) {
        int ang = GeometryFuncs.NormalizeAngle(ang_deg);
        switch (ang) {
            case 0: {
                AbstractUnit.tmp.x = 1;
                AbstractUnit.tmp.y = 0;
                break;
            }
            case 45: {
                AbstractUnit.tmp.x = 1;
                AbstractUnit.tmp.y = 1;
                break;
            }
            case 90: {
                AbstractUnit.tmp.x = 0;
                AbstractUnit.tmp.y = 1;
                break;
            }
            case 135: {
                AbstractUnit.tmp.x = -1;
                AbstractUnit.tmp.y = 1;
                break;
            }
            case 180: {
                AbstractUnit.tmp.x = -1;
                AbstractUnit.tmp.y = 0;
                break;
            }
            case 225: {
                AbstractUnit.tmp.x = -1;
                AbstractUnit.tmp.y = -1;
                break;
            }
            case 270: {
                AbstractUnit.tmp.x = 0;
                AbstractUnit.tmp.y = -1;
                break;
            }
            case 315: {
                AbstractUnit.tmp.x = 1;
                AbstractUnit.tmp.y = -1;
                break;
            }
            default: {
                throw new RuntimeException("Unknown angle: " + ang_deg);
            }
        }
        return tmp;
    }

    public void changeCurrentItem(EquipmentData equipment) {
        this.unit_data.current_item = equipment;
    }

    @Override
    public void process(long interpolation) {
        float move_dist;
        MyPointF target_pos = new MyPointF((float)this.unit_data.getMapX() * Statics.SQ_SIZE, (float)this.unit_data.getMapY() * Statics.SQ_SIZE);
        float dist_to_target = this.getWorldTopLeft_CreatesNew().distance(target_pos);
        if (dist_to_target <= (move_dist = Statics.UNIT_SPEED * (float)interpolation)) {
            this.setLocation((float)this.unit_data.getMapX() * Statics.SQ_SIZE, (float)this.unit_data.getMapY() * Statics.SQ_SIZE);
            this.updateGeometricState();
            this.game.removeFromProcess(this);
            this.game.unitFinishedMoving(this.unit_data);
            this.anim_standStill();
        } else {
            float y_off;
            MyPointF move_dir = target_pos.subtract(this.getWorldTopLeft_CreatesNew()).normalize();
            float x_off = move_dir.x * move_dist;
            if (x_off > dist_to_target) {
                x_off = dist_to_target;
            }
            if ((y_off = move_dir.y * move_dist) > dist_to_target) {
                y_off = dist_to_target;
            }
            this.adjustLocation(x_off, y_off);
            this.updateGeometricState();
            if (this.game.current_unit == this.unit_data) {
                this.game.root_cam.lookAt(this, false);
            }
        }
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            if (this.current_bmp != null) {
                g.drawImage(this.current_bmp, this.world_bounds.left - cam.left - SIZE_DIFF + this.centre_offset, this.world_bounds.top - cam.top - SIZE_DIFF + this.centre_offset, this.paint);
                if (this.game.game_data.num_players > 2 && this.unit_data.getSide() != this.game.game_data.our_side) {
                    g.drawText(this.game.game_data.players_name_by_side[this.unit_data.getSide()], this.world_bounds.left - cam.left - SIZE_DIFF + this.centre_offset, this.world_bounds.top - cam.top - SIZE_DIFF + this.centre_offset, paint_unit_name);
                }
            }
            if (this.unit_data.on_fire > 0) {
                g.drawImage(bmp_on_fire, this.world_bounds.left - cam.left - SIZE_DIFF + this.centre_offset, this.world_bounds.top - cam.top - SIZE_DIFF + this.centre_offset, this.paint);
            }
            if (this.game.current_unit != null && this == this.game.current_unit.model) {
                int img_num = this.game.current_unit.angle / 45;
                g.drawImage(unit_highlighters[img_num], this.world_bounds.left - cam.left - SIZE_DIFF, this.world_bounds.top - cam.top - SIZE_DIFF, this.paint);
            }
            if (!this.game.game_data.areSidesFriends(this.game.game_data.our_side, this.unit_data.getSide())) {
                if (this.enemy_highlighter == null) {
                    this.enemy_highlighter = new EnemyHighlighter();
                }
                this.enemy_highlighter.doDraw(g, this.getWorldCentreX() - cam.left, this.getWorldCentreY() - cam.top);
            }
        }
    }
}

