/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.campaign.SelectCampaignSquadModule;
import com.scs.stellarforces.start.CurrentGameDetailsModule;
import com.scs.stellarforces.start.GetGameDataModule;
import com.scs.stellarforces.start.GetGamesModule;
import com.scs.stellarforces.start.StartOrJoinGameModule;
import com.scs.stellarforces.start.equip.GetEquipmentDataModule;
import dsr.data.GameData;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractOptionsModule2;
import ssmith.lang.NumberFunctions;

public final class ListGamesModule
extends AbstractOptionsModule2 {
    private static final String REFRESH_CMD = "Refresh List";
    private static final String START_NEW_CMD = "Start New Game";
    private ArrayList<GameData> available_games;
    private static Paint paint_text = new Paint();
    private static Paint paint_title = new Paint();

    static {
        paint_text.setARGB(255, 255, 255, 255);
        paint_text.setAntiAlias(true);
        paint_title.setARGB(255, 200, 200, 200);
        paint_title.setAntiAlias(true);
        paint_text.setTypeface(Statics.stdfnt);
        paint_title.setTypeface(Statics.bigfnt);
    }

    public ListGamesModule(AbstractActivity act, ArrayList<GameData> games, boolean auto_select) {
        super(act, 4, 1, paint_text, "lumin_green_button2", -1, auto_select, "Select Game to Play", true);
        this.setBackground("space1.jpg");
        this.available_games = games;
    }

    @Override
    public void getOptions() {
        if (this.available_games != null) {
            for (GameData game : this.available_games) {
                String s = "";
                if (game.haveWeEquipped() && game.haveWeDeployed() && (game.turn_side != game.our_side || game.game_status == 20)) continue;
                s = String.valueOf(s) + game.getFullTitle();
                this.addOption(s, "" + game.game_id);
            }
        }
        if (super.getNumOfOptions() == 0) {
            this.setTitle("You currently have no turns to take!");
        }
        if (super.getNumOfOptions() != 1 || !this.auto_select) {
            this.addOption(START_NEW_CMD);
            this.addOption(REFRESH_CMD);
        }
    }

    @Override
    public void optionSelected(int idx) {
        AbstractActivity act = Statics.act;
        try {
            String cmd = super.getButtonText(idx);
            if (cmd.equalsIgnoreCase(REFRESH_CMD)) {
                super.getMainThread().setNextModule(new GetGamesModule(act, false));
            } else if (cmd.equalsIgnoreCase(START_NEW_CMD)) {
                super.getMainThread().setNextModule(new StartOrJoinGameModule(act));
            } else {
                int gameid = NumberFunctions.ParseInt(super.getActionCommand(idx));
                GameData game = this.findGame(gameid);
                if (game.haveWeEquipped() && game.haveWeDeployed() && (game.turn_side != game.our_side || game.game_status == 20)) {
                    super.getMainThread().setNextModule(new CurrentGameDetailsModule(act, this, game, false));
                } else if (game.has_side_equipped[game.our_side] == 0) {
                    if (game.is_camp_game == 1 && !game.haveWeChosenCampUnits()) {
                        super.getMainThread().setNextModule(new SelectCampaignSquadModule(act, 2, game));
                    } else {
                        super.getMainThread().setNextModule(new GetEquipmentDataModule(act, game));
                    }
                } else if (game.has_side_deployed[game.our_side] == 0 || game.turn_side == game.our_side) {
                    super.getMainThread().setNextModule(new GetGameDataModule(act, game));
                } else {
                    super.getMainThread().setNextModule(new CurrentGameDetailsModule(act, this, game, false));
                }
            }
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }

    private GameData findGame(int gameid) {
        for (GameData game : this.available_games) {
            if (game.game_id != gameid) continue;
            return game;
        }
        return null;
    }

    @Override
    public void doDraw(Canvas c, long interpol) {
        super.doDraw(c, interpol);
    }
}

