/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.SimpleAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.PasswordField;
import ssmith.android.lib2d.gui.TextBox;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class LoginModule
extends SimpleAbstractModule {
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.8f;
    private static final float ICON_HEIGHT = Statics.SCREEN_HEIGHT / 7;
    private Label lbl_login;
    private Label lbl_pwd;
    private TextBox txt_login;
    private PasswordField txt_pwd;
    private Button cmd_ok;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
    }

    public LoginModule(AbstractActivity act) {
        super(0);
        paint_large_text.setTypeface(Statics.stdfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        BufferedImage bmp = Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT);
        this.lbl_login = new Label("Login", "Login or Email Address", ICON_WIDTH, ICON_HEIGHT, null, paint_large_text, false);
        this.txt_login = new TextBox("Login", "", null, paint_large_text, -1, bmp);
        this.lbl_pwd = new Label("Pwd", act.getString("password"), ICON_WIDTH, ICON_HEIGHT, null, paint_large_text, false);
        this.txt_pwd = new PasswordField("Pwd", "", null, paint_large_text, -1, bmp);
        this.cmd_ok = new Button("OK", act.getString("ok"), null, paint_large_text, bmp);
        VerticalFlowLayout layout = new VerticalFlowLayout("Menu", 5.0f);
        layout.attachChild(this.lbl_login);
        layout.attachChild(this.txt_login);
        layout.attachChild(this.lbl_pwd);
        layout.attachChild(this.txt_pwd);
        layout.attachChild(this.cmd_ok);
        Label lbl_help1 = new Label("Help", "Forgotton login/password?  Just send an email", ICON_WIDTH, ICON_HEIGHT, null, paint_normal_text, false);
        layout.attachChild(lbl_help1);
        Label lbl_help2 = new Label("Help", "to 'support@stellarforces.com' with details.", ICON_WIDTH, ICON_HEIGHT, null, paint_normal_text, false);
        layout.attachChild(lbl_help2);
        this.stat_node.attachChild(layout);
        this.stat_node.updateGeometricState();
        this.stat_cam.lookAt(layout, true);
        this.setBackground("space1.jpg");
        this.txt_login.setText(Statics.LAST_LOGIN);
        this.txt_pwd.setText(Statics.LAST_PWD);
    }

    @Override
    public void started() {
        if (Statics.data.containsKey("login")) {
            this.txt_login.setText(Statics.data.get("login"));
        } else if (Statics.data.containsKey("pwd")) {
            this.txt_pwd.setText(Statics.data.get("pwd"));
        }
        Statics.data.clear();
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        if (c == this.txt_login) {
            inputComponent = this.txt_login;
        } else if (c == this.txt_pwd) {
            inputComponent = this.txt_pwd;
        } else if (c == this.cmd_ok) {
            if (this.txt_login.getText().trim().length() == 0) {
                this.showToast("Please enter a login");
                return;
            }
            if (this.txt_pwd.getText().trim().length() == 0) {
                this.showToast("Please enter a password");
                return;
            }
            Statics.LAST_LOGIN = this.txt_login.getText().trim();
            Statics.LAST_PWD = this.txt_pwd.getText().trim();
            super.getMainThread().setNextModule(Statics.GetModule(5));
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode) {
        if (resultCode == 1) {
            this.started();
        }
    }
}

