/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.instructions.InstructionsModule;
import com.scs.stellarforces.start.GetGamesModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.WGet_SF;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.ErrorReporter;
import ssmith.android.framework.modules.SimpleAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.shapes.BitmapRectangle;
import ssmith.lang.NumberFunctions;
import ssmith.util.Browser;

public class MenuModule
extends SimpleAbstractModule {
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.4f;
    private static final float ICON_HEIGHT = (float)Statics.SCREEN_HEIGHT * 0.15f;
    private static final String CMD_TAKE_TURN = "Take Turn";
    private static final String CMD_START_NEW_GAME = "Start or Join Game";
    private static final String CMD_MESSAGES = "Messages";
    private static final String CMD_FORUM = "Forum";
    private static final String CMD_MORE = "More Options";
    private static final String CMD_INSTRUCTIONS = "Manual";
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();
    private static Paint paint_small_text = new Paint();
    private Button btn_play_games;
    private Button btn_start_new;
    private Button btn_messages;
    private Button btn_more;
    private Button btn_instructions;
    private Button btn_forum;
    private Label website;
    private long last_time;
    private static String msg_from_server = "";

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_small_text.setARGB(255, 255, 255, 255);
        paint_small_text.setAntiAlias(true);
    }

    public MenuModule(AbstractActivity act) {
        super(0);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        paint_small_text.setTypeface(Statics.iconfnt);
        this.setBackground("space1.jpg");
        this.start();
    }

    @Override
    public void started() {
        this.stat_node.removeAllChildren();
        BitmapRectangle l_title = new BitmapRectangle("Title", Statics.img_cache.getImageByKey_HeightOnly("sf_logo2_small", (float)Statics.SCREEN_HEIGHT * 0.2f), 0.0f, 0.0f);
        l_title.setCentre(Statics.SCREEN_WIDTH / 2, l_title.getHeight() * 0.6f);
        this.stat_node.attachChild(l_title);
        try {
            if (Statics.players_data_tbl != null) {
                Label l = new Label("Details", "Logged in as " + Statics.players_data_tbl.getString("DisplayName") + "/" + Statics.players_data_tbl.getString("Email"), 10.0f, paint_small_text.getTextSize(), null, paint_small_text, true);
                this.stat_node.attachChild(l);
            }
        }
        catch (Exception ex) {
            ErrorReporter.getInstance().handleSilentException(ex);
        }
        GridLayout menu_node = new GridLayout("Menu", ICON_WIDTH, ICON_HEIGHT, Statics.GetButtonSpacing());
        this.btn_play_games = new Button(CMD_TAKE_TURN, CMD_TAKE_TURN, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_play_games, 0, 0);
        this.btn_start_new = new Button(CMD_START_NEW_GAME, CMD_START_NEW_GAME, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_start_new, 1, 0);
        this.btn_messages = new Button(CMD_MESSAGES, CMD_MESSAGES, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_messages, 0, 1);
        this.btn_forum = new Button(CMD_FORUM, CMD_FORUM, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_forum, 1, 1);
        this.btn_instructions = new Button(CMD_INSTRUCTIONS, CMD_INSTRUCTIONS, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_instructions, 0, 2);
        this.btn_more = new Button(CMD_MORE, CMD_MORE, 0.0f, 0.0f, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(this.btn_more, 1, 2);
        menu_node.updateGeometricState();
        menu_node.setCentre(Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT * 0.45f);
        this.stat_node.attachChild(menu_node);
        Label server_msg = new Label("server_msg", msg_from_server, null, paint_normal_text);
        server_msg.setCentre(Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT - paint_normal_text.getTextSize() * 3.0f);
        this.stat_node.attachChild(server_msg);
        this.website = new Label("Website", "If you like this game, please consider supporting it via Patreon (click here)", null, paint_normal_text);
        this.website.setCentre(Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT - paint_normal_text.getTextSize());
        this.website.collides = true;
        this.stat_node.attachChild(this.website);
        this.stat_node.updateGeometricState();
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c == this.website) {
            String url = Statics.URL_FOR_PATREON;
            Browser.OpenBrowser(url);
        } else if (c == this.btn_play_games) {
            super.getMainThread().setNextModule(new GetGamesModule(act, true));
        } else if (c == this.btn_start_new) {
            super.getMainThread().setNextModule(Statics.GetModule(9));
        } else if (c == this.btn_more) {
            super.getMainThread().setNextModule(Statics.GetModule(13));
        } else if (c == this.btn_forum) {
            String url = "http://www.stellarforces.com/dsr/forums/ForumMainPage.cls";
            Browser.OpenBrowser(url);
        } else if (c == this.btn_messages) {
            super.getMainThread().setNextModule(Statics.GetModule(11));
        } else if (c == this.btn_instructions) {
            super.getMainThread().setNextModule(new InstructionsModule(act, this));
        } else {
            this.returnTo();
        }
    }

    @Override
    public void run() {
        AbstractActivity act = Statics.act;
        try {
            if (System.currentTimeMillis() - this.last_time > 300000L) {
                String response;
                this.last_time = System.currentTimeMillis();
                WGet_SF wc = new WGet_SF(act, null, "cmd=get_num_unread_messages&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD));
                String r = wc.getResponse();
                if (NumberFunctions.IsNumeric(r)) {
                    int i = NumberFunctions.ParseInt(r);
                    if (i > 1) {
                        this.showToast("You have " + i + " unread messages!");
                    } else if (i > 0) {
                        this.showToast("You have an unread message!");
                    }
                }
                if ((wc = new WGet_SF(act, null, "cmd=get_server_msg&comms_version=" + Statics.COMMS_VERSION + "&app_version=" + 1.4f + "&full=1&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD))).getResponseCode() == 200 && !(response = wc.getResponse()).equalsIgnoreCase("error")) {
                    msg_from_server = response;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

