/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.joingame;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.GetGamesModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.lang.NumberFunctions;
import ssmith.util.Browser;

public class NewGameDetailsModule
extends SimpleScrollingAbstractModule {
    private int reqid;
    private DataTable new_games;
    private Button[] cmd_accept;
    private Button cmd_show_mission;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
    }

    public NewGameDetailsModule(AbstractActivity act, AbstractModule ret, int _reqid, DataTable _new_games) {
        super(-1);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.mod_return_to = ret;
        this.reqid = _reqid;
        this.new_games = _new_games;
        this.new_games.find("GameRequestID", this.reqid);
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        this.showControls();
    }

    private void showControls() {
        Label l = new Label("Title", "Game Details", 0.0f, 0.0f, null, paint_large_text, true);
        l.setCentre(Statics.SCREEN_WIDTH / 2, paint_large_text.getTextSize());
        this.root_node.attachChild(l);
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", (float)Statics.SCREEN_HEIGHT * 0.05f);
        vfl.setLocation(0.0f, (float)Statics.SCREEN_HEIGHT * 0.2f);
        StringBuffer str = new StringBuffer();
        if (this.new_games.containsColumn("ForUs") && this.new_games.getString("ForUs").equalsIgnoreCase("1")) {
            str.append("This game has been specifically created with you as an opponent.  Only you can join it!\n\n");
        }
        str.append("Mission: " + this.new_games.getString("MissionName") + "\n");
        str.append("Creator: " + this.new_games.getString("Player1Name") + "\n");
        str.append("Sides: " + this.new_games.getString("NumSides") + "\n");
        if (this.new_games.getString("Comment").length() > 0) {
            str.append("Comment: " + this.new_games.getString("Comment") + "\n");
        }
        if (this.new_games.getInt("GameType") == 1) {
            str.append("Is a Practise game\n");
        } else {
            str.append("Points for Win: " + this.new_games.getInt("PointsForWin") + "\n");
            str.append("Points for Lose: " + this.new_games.getInt("PointsForLose") + "\n");
        }
        if (this.new_games.getInt("Advanced") != 0) {
            str.append("Is ADVANCED mode\n");
        }
        String[] side_names = this.new_games.getString("SideNames").split(",", -1);
        int s = 1;
        while (s <= this.new_games.getInt("NumSides")) {
            str.append("Side " + s + ": " + side_names[s - 1] + "\n");
            ++s;
        }
        MultiLineLabel label2 = new MultiLineLabel("credits", str.toString(), null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
        label2.setLocation(10.0f, (float)Statics.SCREEN_HEIGHT * 0.15f);
        vfl.attachChild(label2);
        label2.updateGeometricState();
        this.cmd_show_mission = new Button("View\nMission\nDetails", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.33f, paint_normal_text.getTextSize() * 7.0f));
        this.cmd_show_mission.setLocation((float)Statics.SCREEN_WIDTH * 0.6f, (float)Statics.SCREEN_HEIGHT * 0.25f);
        this.root_node.attachChild(this.cmd_show_mission);
        HorizontalFlowGridLayout hfl = new HorizontalFlowGridLayout("hfl", (float)Statics.SCREEN_WIDTH * 0.005f);
        String[] sides = this.new_games.getString("SidesAvailable").split(",", -1);
        this.cmd_accept = new Button[sides.length];
        float width = (float)Statics.SCREEN_WIDTH * 0.9f / (float)sides.length;
        float height = (float)Statics.SCREEN_HEIGHT / 7.0f;
        int b = 0;
        while (b < sides.length) {
            this.cmd_accept[b] = new Button(sides[b], "Select Side " + sides[b], null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", width, height));
            hfl.attachChild(this.cmd_accept[b]);
            ++b;
        }
        vfl.attachChild(hfl);
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        block4: {
            AbstractActivity act = Statics.act;
            try {
                if (!(c instanceof Button)) break block4;
                if (c == this.cmd_show_mission) {
                    String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + this.new_games.getInt("MissionType") + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
                    Browser.OpenBrowser(url);
                    break block4;
                }
                this.showPleaseWait("Please Wait");
                Button b = (Button)c;
                String tmp = b.getActionCommand();
                int side = NumberFunctions.ParseInt(tmp);
                String cmd = "cmd=join_game&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&reqid=" + this.new_games.getInt("GameRequestID") + "&side=" + side;
                WGet_SF wget = new WGet_SF(act, null, cmd);
                String response = wget.getResponse();
                this.dismissPleaseWait();
                if (response.length() == 0 || response.equalsIgnoreCase("ok")) {
                    this.getMainThread().setNextModule(new GetGamesModule(act, true));
                    break block4;
                }
                throw new RuntimeException(response);
            }
            catch (Exception ex) {
                AbstractActivity.HandleError(ex);
            }
        }
    }
}

