/*
 * Decompiled with CFR 0.152.
 */
package dsr.data;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.graphics.DummyWall;
import dsr.data.MapSquare;
import ssmith.android.lib2d.MyPickResults;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.PickData;
import ssmith.android.lib2d.Ray;
import ssmith.android.lib2d.shapes.Line;
import ssmith.astar.IAStarMapInterface;
import ssmith.util.MyList;

public final class ClientMapData
implements IAStarMapInterface {
    private MapSquare[][] mapdata;
    private static MyList<Integer> ignore_floor_tex = MyList.CreateFromInts(86, 87, 88, 85, 5, 72, 73, 74, 2, 93);

    public ClientMapData(MapSquare[][] data) {
        this.mapdata = data;
    }

    public MapSquare getSqFromPixels_MaybeNULL(int px, int pz) {
        return this.getSq_MaybeNULL((int)((float)px / Statics.SQ_SIZE), (int)((float)pz / Statics.SQ_SIZE));
    }

    public MapSquare getSq_MaybeNULL(int x, int z) {
        try {
            return this.mapdata[x][z];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public int getMapWidth() {
        return this.mapdata.length;
    }

    @Override
    public int getMapHeight() {
        return this.mapdata[0].length;
    }

    public void canSee(Ray r, MyPickResults results, boolean ignore_smoke, boolean ignore_cpu) {
        if (r.getDirection().x != r.getDirection().x || r.getDirection().y != r.getDirection().y) {
            return;
        }
        float px = r.getOrigin().x;
        float py = r.getOrigin().y;
        float jump = Statics.SQ_SIZE / 4.0f;
        float dist = 0.0f;
        int iterations = 0;
        int last_x = -1;
        int last_y = -1;
        while (true) {
            int mx = (int)((px += r.getDirection().x * jump) / Statics.SQ_SIZE);
            int my = (int)((py += r.getDirection().y * jump) / Statics.SQ_SIZE);
            if (iterations > 1 && (mx != last_x || my != last_y)) {
                last_x = mx;
                last_y = my;
                MapSquare sq = this.getSq_MaybeNULL(mx, my);
                if (sq != null) {
                    if (sq.door_type > 0 && !sq.door_open || sq.major_type == 0 || sq.major_type == 3 || sq.major_type == 2 && !ignore_cpu || sq.smoke_type > 0 && !ignore_smoke) {
                        if (sq.smoke_type > 0 && ignore_smoke && (sq.door_type <= 0 || sq.door_open)) continue;
                        PickData p = new PickData(new DummyWall(null, sq, mx, my), dist);
                        results.add(p);
                        return;
                    }
                } else {
                    return;
                }
            }
            dist += jump;
            ++iterations;
        }
    }

    public int getBlockCountInLOS_Pixels_Centre(int map_sx, int map_sy, int map_ex, int map_ey, boolean ignore_smoke, boolean ignore_cpu) {
        float sx = (float)map_sx * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        float sy = (float)map_sy * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        float ex = (float)map_ex * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        float ey = (float)map_ey * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        return this.getBlockCountInLOS_Pixels(map_ex, map_ey, sx, sy, ex, ey, ignore_smoke, ignore_cpu);
    }

    public boolean isLOS_Faces(int map_sx, int map_sy, int map_ex, int map_ey, boolean ignore_smoke, boolean ignore_cpu) {
        boolean b;
        float sx = (float)map_sx * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        float sy = (float)map_sy * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        float ex = (float)map_ex * Statics.SQ_SIZE;
        float ey = (float)map_ey * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
        boolean bl = b = this.getBlockCountInLOS_Pixels(map_ex, map_ey, sx, sy, ex, ey, ignore_smoke, ignore_cpu) <= 0;
        if (!b) {
            ex = (float)map_ex * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
            ey = (float)map_ey * Statics.SQ_SIZE;
            boolean bl2 = b = this.getBlockCountInLOS_Pixels(map_ex, map_ey, sx, sy, ex, ey, ignore_smoke, ignore_cpu) <= 0;
            if (!b) {
                ex = (float)map_ex * Statics.SQ_SIZE + Statics.SQ_SIZE - 1.0f;
                ey = (float)map_ey * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
                boolean bl3 = b = this.getBlockCountInLOS_Pixels(map_ex, map_ey, sx, sy, ex, ey, ignore_smoke, ignore_cpu) <= 0;
                if (!b) {
                    ex = (float)map_ex * Statics.SQ_SIZE + Statics.SQ_SIZE * 0.5f;
                    ey = (float)map_ey * Statics.SQ_SIZE + Statics.SQ_SIZE - 1.0f;
                    boolean bl4 = b = this.getBlockCountInLOS_Pixels(map_ex, map_ey, sx, sy, ex, ey, ignore_smoke, ignore_cpu) <= 0;
                    if (!b) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private int getBlockCountInLOS_Pixels(int map_ex, int map_ey, float pixel_sx, float pixel_sy, float pixel_ex, float pixel_ey, boolean ignore_smoke, boolean ignore_cpu) {
        int count = 0;
        if (pixel_sx != pixel_ex || pixel_sy != pixel_ey) {
            Line l = new Line("LOS", new MyPointF(pixel_sx, pixel_sy), new MyPointF(pixel_ex, pixel_ey), null);
            float px = l.getWorldStart().x;
            float py = l.getWorldStart().y;
            MyPointF dir = l.getVector().normalize();
            float jump = Statics.SQ_SIZE / 4.0f;
            float dist = 0.0f;
            int last_x = -1;
            int last_y = -1;
            while (dist <= l.getLength()) {
                int mx = (int)((px += dir.x * jump) / Statics.SQ_SIZE);
                int my = (int)((py += dir.y * jump) / Statics.SQ_SIZE);
                if (mx != last_x || my != last_y) {
                    MapSquare sq;
                    last_x = mx;
                    last_y = my;
                    if (mx == map_ex && my == map_ey || (sq = this.getSq_MaybeNULL(mx, my)) == null) break;
                    if (sq.door_type > 0 && !sq.door_open || sq.major_type == 0 || sq.major_type == 3 || sq.major_type == 2 && !ignore_cpu || sq.smoke_type > 0 && !ignore_smoke) {
                        if (sq.smoke_type > 0 && ignore_smoke && (sq.door_type <= 0 || sq.door_open)) continue;
                        ++count;
                    }
                }
                dist += jump;
            }
        }
        return count;
    }

    public int getAdjacentTexCode(MapSquare sq, int major_type) {
        int y = sq.y - 1;
        while (y <= sq.y + 1) {
            int x = sq.x - 1;
            while (x <= sq.x + 1) {
                MapSquare adj;
                if (!(x == sq.x && (y == sq.y || x != sq.x && y != sq.y) || (adj = this.getSq_MaybeNULL(x, y)) == null || major_type == 1 && ignore_floor_tex.contains(adj.texture_code) || adj.major_type != major_type)) {
                    return adj.texture_code;
                }
                ++x;
            }
            ++y;
        }
        return -1;
    }

    @Override
    public boolean isMapSquareTraversable(int x, int z) {
        MapSquare sq = this.getSq_MaybeNULL(x, z);
        return sq.isTraversable();
    }

    @Override
    public float getMapSquareDifficulty(int x, int z) {
        return 1.0f;
    }
}

