/*
 * Decompiled with CFR 0.152.
 */
package dsr.data;

import com.scs.stellarforces.graphics.SlidingDoor;
import dsr.data.EquipmentData;
import java.util.ArrayList;

public final class MapSquare {
    public int x;
    public int y;
    public int major_type;
    public byte owner_side;
    public int texture_code;
    public short raised_texture_code;
    public byte door_type = (byte)-1;
    public byte deploy_sq_side = (byte)-1;
    public byte escape_hatch_side = (byte)-1;
    public byte destroyed = 0;
    public boolean door_open = false;
    public short scenery_code;
    public int sq_id;
    public SlidingDoor door;
    private ArrayList<EquipmentData> equipment;
    public byte smoke_type;
    public int smoke_caused_by;

    public MapSquare(int id, byte t, byte _x, byte _y, byte deploy, byte escape, short floor_tex, byte _destroyed, byte _door_open, short raised_tex, byte _smoke_type, int _smoke_caused_by, byte owner_side) {
        this.x = _x;
        this.y = _y;
        this.major_type = t;
        this.destroyed = _destroyed;
        this.door_open = _door_open == 1;
        this.sq_id = id;
        this.deploy_sq_side = deploy;
        this.escape_hatch_side = escape;
        this.texture_code = floor_tex;
        this.raised_texture_code = raised_tex;
        this.smoke_type = _smoke_type;
        this.smoke_caused_by = _smoke_caused_by;
        this.owner_side = owner_side;
    }

    public String toString() {
        return "Mapsquare (" + this.x + ", " + this.y + ")";
    }

    public void addEquipment(EquipmentData eq) {
        if (this.equipment == null) {
            this.equipment = new ArrayList(5);
        }
        this.equipment.add(eq);
    }

    public void removeEquipment(EquipmentData eq) {
        this.equipment.remove(eq);
        if (this.equipment.size() == 0) {
            this.equipment = null;
        }
    }

    public ArrayList<EquipmentData> getEquipment_MaybeNULL() {
        return this.equipment;
    }

    public boolean contains(EquipmentData eq) {
        if (this.equipment != null) {
            return this.equipment.contains(eq);
        }
        return false;
    }

    public String getListOfEquipment(int advanced_mode, int side) {
        if (this.equipment != null) {
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < this.equipment.size()) {
                EquipmentData eq = this.equipment.get(i);
                if (advanced_mode != 1 || eq.seen_by_side[side] != 0) {
                    str.append(String.valueOf(eq.getName(false)) + ", ");
                }
                ++i;
            }
            if (str.length() > 2) {
                str.delete(str.length() - 2, str.length());
            }
            return str.toString();
        }
        return "";
    }

    public boolean containsType(int type) {
        if (this.equipment != null) {
            int i = 0;
            while (i < this.equipment.size()) {
                EquipmentData eq = this.equipment.get(i);
                if (eq.major_type == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isTraversable() {
        return this.major_type == 1 && this.texture_code != 11;
    }

    public boolean castsShadow() {
        return this.major_type == 3 || this.major_type == 2;
    }
}

