/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d;

import ssmith.android.compatibility.PointF;
import ssmith.lang.GeometryFuncs;

public class MyPointF
extends PointF {
    public MyPointF() {
        this(0.0f, 0.0f);
    }

    public MyPointF(float x, float y) {
        super(x, y);
    }

    public String toString() {
        return String.valueOf(this.x) + "," + this.y;
    }

    public MyPointF subtract(MyPointF o) {
        MyPointF newone = new MyPointF(this.x, this.y);
        newone.x -= o.x;
        newone.y -= o.y;
        return newone;
    }

    public MyPointF multiply(float o) {
        MyPointF newone = new MyPointF(this.x, this.y);
        newone.x *= o;
        newone.y *= o;
        return newone;
    }

    public MyPointF multiplyLocal(float o) {
        this.x *= o;
        this.y *= o;
        return this;
    }

    public MyPointF notFactorial(float o) {
        MyPointF newone = new MyPointF(this.x, this.y);
        newone.x = o / newone.x;
        newone.y = o / newone.y;
        return newone;
    }

    public MyPointF notFactorialLocal(float o) {
        float len = this.length();
        len = o / len;
        this.x *= len;
        this.y *= len;
        return this;
    }

    public MyPointF subtract(float x, float y) {
        MyPointF newone = new MyPointF(this.x, this.y);
        newone.x -= x;
        newone.y -= y;
        return newone;
    }

    public MyPointF subtractLocal(MyPointF o) {
        return this.subtractLocal(o.x, o.y);
    }

    public MyPointF subtractLocal(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public MyPointF add(MyPointF other) {
        MyPointF pf = new MyPointF(this.x, this.y);
        pf.x += other.x;
        pf.y += other.y;
        return pf;
    }

    public MyPointF averageLocal(MyPointF other) {
        this.x = (this.x + other.x) / 2.0f;
        this.y = (this.y + other.y) / 2.0f;
        return this;
    }

    public MyPointF normalizeLocal() {
        float len = this.length();
        this.x /= len;
        this.y /= len;
        return this;
    }

    public MyPointF normalize() {
        float len = this.length();
        float x2 = this.x / len;
        float y2 = this.y / len;
        return new MyPointF(x2, y2);
    }

    public float distance(MyPointF t) {
        return GeometryFuncs.distance(this.x, this.y, t.x, t.y);
    }

    public MyPointF copy() {
        return this.multiply(1.0f);
    }
}

