/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.gui;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.RectF;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.ToggleButtonGroup;

public class ToggleButton
extends Button {
    private RectF temp_rect2 = new RectF();
    private boolean selected = false;
    private Paint deselected_background_paint_and_ink;
    private BufferedImage deselected_bmp;
    private ToggleButtonGroup group;

    public ToggleButton(String cmd, String _text, Paint paint, Paint _deselected_background_paint, Paint ink, BufferedImage bmp, BufferedImage _deselected_bmp) {
        super(cmd, _text, paint, ink, bmp);
        this.deselected_background_paint_and_ink = _deselected_background_paint;
        this.deselected_bmp = _deselected_bmp;
    }

    public ToggleButton(String _text, Paint paint, Paint _deselected_background_paint, Paint ink, BufferedImage bmp, BufferedImage _deselected_bmp) {
        this(_text, _text, paint, _deselected_background_paint, ink, bmp, _deselected_bmp);
    }

    public void setGroup(ToggleButtonGroup g) {
        g.add(this);
        this.group = g;
    }

    public ToggleButton(String cmd, String _text, float x, float y, Paint paint, Paint _deselected_background_paint, Paint ink, BufferedImage bmp, BufferedImage _deselected_bmp) {
        super(String.valueOf(cmd) + "_Btn", cmd, _text, x, y, paint, ink, bmp);
        this.deselected_background_paint_and_ink = _deselected_background_paint;
        this.deselected_bmp = _deselected_bmp;
    }

    public static void SetAll(ArrayList<Spatial> children, boolean b) {
        for (Spatial s : children) {
            if (s instanceof ToggleButton) {
                ToggleButton t = (ToggleButton)s;
                t.setSelected(b);
                continue;
            }
            if (!(s instanceof Node)) continue;
            Node n = (Node)s;
            ToggleButton.SetAll(n.getChildren(), b);
        }
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.selected) {
            super.doDraw(g, cam, interpol);
        } else if (this.visible) {
            if (this.deselected_bmp == null) {
                this.temp_rect2.set(this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.world_bounds.right - cam.left, this.world_bounds.bottom - cam.top);
                g.drawRect(this.temp_rect2, this.deselected_background_paint_and_ink);
            } else {
                g.drawImage(this.deselected_bmp, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.deselected_background_paint_and_ink);
            }
            super.drawText(g, cam);
        }
    }

    public void toggeSelected() {
        this.setSelected(!this.selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.setSelected(b, true);
    }

    public void setSelected(boolean b, boolean affect_group) {
        this.selected = b;
        if (b && affect_group && this.group != null) {
            this.group.buttonClicked(this);
        }
    }
}

