/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.layouts;

import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.Spatial;

public class GridLayout
extends Node {
    private float spacing;
    private float comp_width;
    private float comp_height;

    public GridLayout(String name, float comp_w, float comp_h, float space) {
        super(name);
        this.spacing = space;
        this.comp_width = comp_w;
        this.comp_height = comp_h;
    }

    @Override
    public void attachChild(Spatial s) {
        throw new RuntimeException("Use attachChild(Spatial s, int grid_x, int grid_y) instead");
    }

    public void attachChild(Spatial s, int grid_x, int grid_y) {
        super.attachChild(s);
        s.updateGeometricState();
        float left = this.spacing * (float)grid_x + this.comp_width * (float)grid_x;
        float top = this.spacing * (float)grid_y + this.comp_height * (float)grid_y;
        float right = this.spacing * (float)grid_x + this.comp_width * (float)(grid_x + 1);
        float bottom = this.spacing * (float)grid_y + this.comp_height * (float)(grid_y + 1);
        if (!(s instanceof Node)) {
            s.setByLTRB(left, top, right, bottom);
        } else {
            s.setLocation(left, top);
        }
    }

    public float getCompWidth() {
        return this.comp_width;
    }

    public float getCompHeight() {
        return this.comp_height;
    }
}

