/*
 * Decompiled with CFR 0.152.
 */
package ssmith.awt;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class ImageCache
extends Hashtable<String, BufferedImage> {
    private static final long serialVersionUID = 1L;
    private static final String IMAGES_DIR = "images/";
    private Component c;

    public ImageCache(Component _c) {
        this.c = _c;
    }

    public BufferedImage getImageByKey_HeightOnly(String filename, float h) {
        return this.getImage(filename, -1, (int)h);
    }

    public BufferedImage getImage(String filename, float w, float h) {
        return this.getImage(filename, (int)w, (int)h);
    }

    public BufferedImage getImage(String filename, int w, int h) {
        if (filename != null && filename.length() > 0) {
            String key;
            BufferedImage img;
            if (!filename.contains(".")) {
                filename = String.valueOf(filename) + ".png";
            }
            if ((img = (BufferedImage)this.get(key = String.valueOf(filename = IMAGES_DIR + filename) + "_" + w + "_" + h)) == null) {
                try {
                    String res_filename = filename;
                    if (res_filename.startsWith(".")) {
                        res_filename = res_filename.substring(2);
                    }
                    BufferedImage bi = null;
                    ClassLoader cl = this.getClass().getClassLoader();
                    InputStream is = cl.getResourceAsStream(res_filename);
                    if (is != null) {
                        bi = ImageIO.read(is);
                    } else {
                        File f = new File(filename);
                        if (!f.canRead()) {
                            throw new FileNotFoundException(filename);
                        }
                        bi = ImageIO.read(f);
                    }
                    img = bi;
                    if (w < 0) {
                        w = (int)((float)img.getWidth() / (float)img.getHeight() * (float)h);
                    }
                    BufferedImage scaled = new BufferedImage(w, h, 2);
                    scaled.getGraphics().drawImage(img, 0, 0, w, h, this.c);
                    img = scaled;
                    this.put(key, img);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return img;
        }
        return null;
    }
}

