/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.Explosion;
import com.scs.stellarforces.graphics.GameObject;
import com.scs.stellarforces.graphics.Sparks;
import java.awt.Color;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.MyPointF;

public class BulletLaser
extends GameObject
implements IProcessable {
    private static final float SIZE = Statics.SQ_SIZE / 2.0f;
    private MyPointF move_dir;
    private MyPointF pixel_end;
    private float max_dist;
    private float dist_so_far = 0.0f;
    private boolean explosion_at_end;
    private boolean track;
    private MyPointF orig_cam_loc;
    private static Paint paintOuter = new Paint();
    private static Paint paintInner;

    static {
        paintOuter.setAntiAlias(true);
        paintOuter.setColor(Color.yellow, 100);
        paintOuter.setStrokeWidth(8.0f);
        paintInner = new Paint();
        paintInner.setColor(Color.red, 200);
        paintInner.setStrokeWidth(4.0f);
    }

    public BulletLaser(GameModule _game, MyPointF pxl_start, MyPointF _pixel_end, boolean explode, boolean _track) {
        super(_game, "BulletLaser", true, pxl_start.x, pxl_start.y, Statics.BULLET_SIZE, Statics.BULLET_SIZE, false, false);
        this.pixel_end = _pixel_end;
        this.move_dir = this.pixel_end.subtract(pxl_start).normalize().multiply(Statics.BULLET_MOVE_DIST);
        this.max_dist = this.pixel_end.subtract(pxl_start).length();
        this.track = _track;
        this.explosion_at_end = explode;
        this.game.attachToRootNode_Top(this, true);
        this.game.addToProcess(this);
        if (this.track) {
            this.orig_cam_loc = this.game.root_cam.getActualCentre().copy();
        }
    }

    @Override
    public void process(long interpol) {
        if (this.move_dir.length() == 0.0f) {
            this.remove();
        } else {
            MyPointF act_dir = this.move_dir.multiply(interpol);
            this.adjustLocation(act_dir);
            this.dist_so_far += act_dir.length();
            this.updateGeometricState();
            if (this.dist_so_far > this.max_dist) {
                this.remove();
            } else if (this.track) {
                this.game.root_cam.lookAt(this, true);
            }
        }
    }

    private void remove() {
        this.game.removeFromProcess(this);
        if (this.explosion_at_end) {
            new Explosion(this.game, this.pixel_end.x, this.pixel_end.y, Statics.SQ_SIZE);
        } else {
            new Sparks(this.game, this.pixel_end.x, this.pixel_end.y);
        }
        if (this.track && this.orig_cam_loc != null) {
            this.game.root_cam.lookAt(this.orig_cam_loc.x, this.orig_cam_loc.y, true);
        }
        this.removeFromParent();
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            float x = this.world_bounds.left - cam.left - SIZE / 2.0f;
            float y = this.world_bounds.top - cam.top - SIZE / 2.0f;
            float x2 = x + this.move_dir.x * Statics.SQ_SIZE;
            float y2 = y + this.move_dir.y * Statics.SQ_SIZE;
            g.drawLine(x, y, x2, y2, paintOuter);
            g.drawLine(x, y, x2, y2, paintInner);
        }
    }
}

