/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.GameObject;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;

public class Explosion
extends GameObject
implements IProcessable {
    private static final int DURATION = 200;
    private int current_frame = 0;
    private long timer = 200L;
    private BufferedImage[] frames = new BufferedImage[7];

    public Explosion(GameModule game, float pxl_centre_x, float pxl_centre_y, float pxl_size) {
        super(game, "Explosion", false, pxl_centre_x - pxl_size / 2.0f, pxl_centre_y - pxl_size / 2.0f, pxl_size, pxl_size, false, false);
        if (pxl_size <= 0.0f) {
            pxl_size = Statics.SQ_SIZE / 2.0f;
        } else if (pxl_size > (float)(Statics.SCREEN_WIDTH / 3)) {
            pxl_size = Statics.SCREEN_WIDTH / 3;
        }
        try {
            this.frames[0] = GameModule.ImgCache.getImage("explosion1", pxl_size, pxl_size);
            this.frames[1] = GameModule.ImgCache.getImage("explosion2", pxl_size, pxl_size);
            this.frames[2] = GameModule.ImgCache.getImage("explosion3", pxl_size, pxl_size);
            this.frames[3] = GameModule.ImgCache.getImage("explosion4", pxl_size, pxl_size);
            this.frames[4] = GameModule.ImgCache.getImage("explosion5", pxl_size, pxl_size);
            this.frames[5] = GameModule.ImgCache.getImage("explosion6", pxl_size, pxl_size);
            this.frames[6] = GameModule.ImgCache.getImage("explosion7", pxl_size, pxl_size);
        }
        catch (OutOfMemoryError ex) {
            ex.printStackTrace();
        }
        game.attachToRootNode_Top(this, true);
        this.updateGeometricState();
        game.addToProcess(this);
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.frames[this.current_frame] != null) {
            g.drawImage(this.frames[this.current_frame], this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
        }
    }

    @Override
    public void process(long interpol) {
        this.timer -= interpol;
        if (this.timer < 0L) {
            this.timer = 200L;
            ++this.current_frame;
            if (this.current_frame >= this.frames.length) {
                this.removeFromParent();
                this.game.removeFromProcess(this);
            }
        }
    }
}

