/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import dsr.data.MapSquare;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.gui.BitmapComponent;
import ssmith.awt.ImageCache;
import ssmith.awt.ImageFunctions;
import ssmith.lang.NumberFunctions;

public class MapSquareImage
extends BitmapComponent {
    private static final float CPU_INSET = Statics.SQ_SIZE * 0.1f;
    private static BufferedImage bmp_door_lr_closed;
    private static BufferedImage bmp_door_ud_closed;
    private static BufferedImage bmp_door_lr_open;
    private static BufferedImage bmp_door_ud_open;
    private static BufferedImage bmp_cpu1;
    private static BufferedImage bmp_cpu2;
    private static BufferedImage bmp_cpu3;
    private static BufferedImage bmp_cpu4;
    private static BufferedImage bmp_cpu_destroyed;
    private static BufferedImage bmp_smoke1;
    private static BufferedImage bmp_smoke2;
    private static BufferedImage bmp_smoke3;
    private static BufferedImage bmp_smoke4;
    private static BufferedImage bmp_fire1;
    private static BufferedImage bmp_fire2;
    private static BufferedImage bmp_fire3;
    private static BufferedImage bmp_fire4;
    private static BufferedImage bmp_nerve_gas1;
    private static BufferedImage bmp_nerve_gas2;
    private static BufferedImage bmp_nerve_gas3;
    private static BufferedImage bmp_nerve_gas4;
    private static BufferedImage bmp_grid;
    public byte x;
    public byte y;
    private MapSquare sq;
    private BufferedImage bmp_smoke;
    private BufferedImage bmp_nerve_gas;
    private BufferedImage bmp_fire;
    public BufferedImage bmp_shad;
    public float shad_offset_x;
    public float shad_offset_y;

    private static void CreateBitmaps(ImageCache img_cache) {
        if (bmp_door_lr_closed == null) {
            bmp_door_lr_closed = img_cache.getImage("door_lr", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
            bmp_door_ud_closed = img_cache.getImage("door_ud", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
            bmp_door_lr_open = img_cache.getImage("door_lr_open", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
            bmp_door_ud_open = img_cache.getImage("door_ud_open", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
            bmp_nerve_gas1 = img_cache.getImage("nerve_gas", Statics.SQ_SIZE + CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_nerve_gas2 = ImageFunctions.Rotate(bmp_nerve_gas1, 90, false);
            bmp_nerve_gas3 = ImageFunctions.Rotate(bmp_nerve_gas2, 90, false);
            bmp_nerve_gas4 = ImageFunctions.Rotate(bmp_nerve_gas3, 90, false);
            bmp_smoke1 = img_cache.getImage("smoke", Statics.SQ_SIZE + CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_smoke2 = ImageFunctions.Rotate(bmp_smoke1, 90, false);
            bmp_smoke3 = ImageFunctions.Rotate(bmp_smoke2, 90, false);
            bmp_smoke4 = ImageFunctions.Rotate(bmp_smoke3, 90, false);
            bmp_fire1 = img_cache.getImage("fire", Statics.SQ_SIZE + CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_fire2 = ImageFunctions.Rotate(bmp_fire1, 90, false);
            bmp_fire3 = ImageFunctions.Rotate(bmp_fire2, 90, false);
            bmp_fire4 = ImageFunctions.Rotate(bmp_fire3, 90, false);
            bmp_cpu1 = img_cache.getImage("computerconsole1.png", Statics.SQ_SIZE - CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_cpu2 = img_cache.getImage("computerconsole2.jpg", Statics.SQ_SIZE - CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_cpu3 = img_cache.getImage("computerconsole3.jpg", Statics.SQ_SIZE - CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_cpu4 = img_cache.getImage("computerconsole4.jpg", Statics.SQ_SIZE - CPU_INSET * 2.0f, Statics.SQ_SIZE + CPU_INSET * 2.0f);
            bmp_cpu_destroyed = img_cache.getImage("damaged_computer.jpg", Statics.SQ_SIZE - CPU_INSET * 2.0f, Statics.SQ_SIZE - CPU_INSET * 2.0f);
            bmp_grid = img_cache.getImage("mapsquare_grid", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
        }
    }

    public MapSquareImage(GameModule game, String name, MapSquare _sq, BufferedImage _bmp, byte map_x, byte map_y) {
        super(name, name, _bmp);
        this.sq = _sq;
        this.x = map_x;
        this.y = map_y;
        MapSquareImage.CreateBitmaps(GameModule.ImgCache);
        BufferedImage bmp = null;
        switch (NumberFunctions.rnd(1, 4)) {
            case 1: {
                bmp = bmp_nerve_gas1;
                break;
            }
            case 2: {
                bmp = bmp_nerve_gas2;
                break;
            }
            case 3: {
                bmp = bmp_nerve_gas3;
                break;
            }
            default: {
                bmp = bmp_nerve_gas4;
            }
        }
        this.bmp_nerve_gas = bmp;
        bmp = null;
        switch (NumberFunctions.rnd(1, 4)) {
            case 1: {
                bmp = bmp_smoke1;
                break;
            }
            case 2: {
                bmp = bmp_smoke2;
                break;
            }
            case 3: {
                bmp = bmp_smoke3;
                break;
            }
            default: {
                bmp = bmp_smoke4;
            }
        }
        this.bmp_smoke = bmp;
        bmp = null;
        switch (NumberFunctions.rnd(1, 4)) {
            case 1: {
                bmp = bmp_fire1;
                break;
            }
            case 2: {
                bmp = bmp_fire2;
                break;
            }
            case 3: {
                bmp = bmp_fire3;
                break;
            }
            default: {
                bmp = bmp_fire4;
            }
        }
        this.bmp_fire = bmp;
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        block21: {
            block22: {
                super.doDraw(g, cam, interpol);
                if (this.sq.door_type > 0) {
                    if (this.sq.door_type == 2) {
                        if (!this.sq.door_open) {
                            g.drawImage(bmp_door_lr_closed, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
                        } else {
                            g.drawImage(bmp_door_lr_open, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
                        }
                    } else if (this.sq.door_type == 1) {
                        if (!this.sq.door_open) {
                            g.drawImage(bmp_door_ud_closed, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
                        } else {
                            g.drawImage(bmp_door_ud_open, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
                        }
                    }
                }
                if (this.sq.smoke_type == 22) {
                    g.drawImage(this.bmp_nerve_gas, this.world_bounds.left - cam.left - CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET, this.paint);
                } else if (this.sq.smoke_type == 21) {
                    g.drawImage(this.bmp_smoke, this.world_bounds.left - cam.left - CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET, this.paint);
                } else if (this.sq.smoke_type == 34) {
                    g.drawImage(this.bmp_fire, this.world_bounds.left - cam.left - CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET, this.paint);
                }
                if (this.sq.major_type != 2) break block21;
                if (this.sq.destroyed != 0) break block22;
                switch (this.sq.owner_side) {
                    case 0: 
                    case 1: {
                        g.drawImage(bmp_cpu1, this.world_bounds.left - cam.left + CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET * 2.0f, this.paint);
                        break block21;
                    }
                    case 2: {
                        g.drawImage(bmp_cpu2, this.world_bounds.left - cam.left + CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET * 2.0f, this.paint);
                        break block21;
                    }
                    case 3: {
                        g.drawImage(bmp_cpu3, this.world_bounds.left - cam.left + CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET * 2.0f, this.paint);
                        break block21;
                    }
                    case 4: {
                        g.drawImage(bmp_cpu4, this.world_bounds.left - cam.left + CPU_INSET, this.world_bounds.top - cam.top - CPU_INSET * 2.0f, this.paint);
                        break block21;
                    }
                    default: {
                        throw new RuntimeException("Unknown owner: " + this.sq.owner_side);
                    }
                }
            }
            g.drawImage(bmp_cpu_destroyed, this.world_bounds.left - cam.left + CPU_INSET, this.world_bounds.top - cam.top + CPU_INSET, this.paint);
        }
        if (this.bmp_shad != null) {
            g.drawImage(this.bmp_shad, this.world_bounds.left - cam.left + this.shad_offset_x, this.world_bounds.top - cam.top + this.shad_offset_y, this.paint);
        }
        if (GameModule.show_grid) {
            g.drawImage(bmp_grid, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
        }
    }
}

