/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics.icons;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.icons.AbstractIcon;

public class MovementIcon
extends AbstractIcon {
    public static final int MOVE_FWD = 1;
    public static final int TURN_RIGHT = 2;
    public static final int SLIDE_RIGHT = 3;
    public static final int MOVE_BACK = 4;
    public static final int SLIDE_LEFT = 5;
    public static final int TURN_LEFT = 6;
    public static final int CENTRE_ON_UNIT = 7;
    public static final int AP_LOCK = 9;
    public static final int QUESTION = 11;
    private int cmd;

    public MovementIcon(GameModule game, String text, int _cmd) {
        this(game, text, _cmd, "menu_frame_yellow");
    }

    public MovementIcon(GameModule game, String text, int _cmd, String r) {
        super(game, r, text);
        this.cmd = _cmd;
    }

    @Override
    public boolean mouseClicked() {
        Statics.act.playSound("type2");
        if (this.game.question && this.cmd != 11) {
            switch (this.cmd) {
                case 1: {
                    this.game.addToHUD("Moves a unit forward one square");
                    break;
                }
                case 4: {
                    this.game.addToHUD("Moves a unit backwards one square");
                    break;
                }
                case 5: {
                    this.game.addToHUD("Moves a unit left one square");
                    break;
                }
                case 3: {
                    this.game.addToHUD("Moves a unit right one square");
                    break;
                }
                case 6: {
                    this.game.addToHUD("Turns a unit left by 45 degrees");
                    break;
                }
                case 2: {
                    this.game.addToHUD("Turns a unit right by 45 degrees");
                    break;
                }
                case 7: {
                    this.game.addToHUD("Centres the camera on the current unit");
                    break;
                }
                case 9: {
                    this.game.addToHUD("Ensures a unit has enough APs for Opp Fire");
                    break;
                }
                case 11: {
                    this.game.addToHUD("Gives help on each icon");
                    break;
                }
                default: {
                    this.game.addToHUD("There is no help on that icon");
                    break;
                }
            }
        } else if (!this.game.areExplosionsScheduled() && this.game.current_unit != null && this.game.current_unit.model != null) {
            switch (this.cmd) {
                case 1: {
                    this.game.current_unit.model.moveFwd();
                    break;
                }
                case 4: {
                    this.game.current_unit.model.moveBack();
                    break;
                }
                case 5: {
                    this.game.current_unit.model.moveStrafeLeft();
                    break;
                }
                case 3: {
                    this.game.current_unit.model.moveStrafeRight();
                    break;
                }
                case 6: {
                    this.game.current_unit.model.turnBy(-45);
                    break;
                }
                case 2: {
                    this.game.current_unit.model.turnBy(45);
                    break;
                }
                case 7: {
                    this.game.selectOurUnit(this.game.current_unit, true);
                    break;
                }
                case 9: {
                    boolean bl = this.game.ap_lock = !this.game.ap_lock;
                    if (this.game.ap_lock) {
                        this.bmp_background = GameModule.ImgCache.getImage("menu_frame_red", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT);
                        this.game.addToHUD("AP Lock ON");
                        break;
                    }
                    this.bmp_background = GameModule.ImgCache.getImage("menu_frame_yellow", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT);
                    this.game.addToHUD("AP Lock off");
                    break;
                }
                case 11: {
                    boolean bl = this.game.question = !this.game.question;
                    if (this.game.question) {
                        this.bmp_background = GameModule.ImgCache.getImage("menu_frame_red", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT);
                        this.game.addToHUD("Icon Help Mode: Please click on another icon for help.  Press this icon again to return to normal mode.");
                        break;
                    }
                    this.bmp_background = GameModule.ImgCache.getImage("menu_frame_yellow", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT);
                    this.game.addToHUD("Normal mode restored");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown movement command: " + this.cmd);
                }
            }
        }
        return true;
    }
}

