/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.playback;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.playback.GetEventDataThread;
import com.scs.stellarforces.playback.GetGameDataThreadForPlayback;
import com.scs.stellarforces.playback.PlayBackGameData;
import com.scs.stellarforces.playback.PlaybackTurnData;
import com.scs.stellarforces.playback.eventgraphics.AbstractEventGraphic;
import com.scs.stellarforces.playback.eventgraphics.ExplosionGraphic;
import com.scs.stellarforces.playback.eventgraphics.ShootingGraphic;
import com.scs.stellarforces.playback.eventgraphics.ThrowingGraphic;
import com.scs.stellarforces.playback.eventgraphics.UnitKilledGraphic;
import dsr.data.UnitData;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.RectF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.lang.Functions;
import ssmith.util.Interval;

public class PlaybackModule
extends SimpleAbstractModule {
    private static Paint paint_text = new Paint();
    private static Paint paint_smoke = new Paint();
    private static Paint paint_nerve_gas = new Paint();
    private static Paint paint_fire = new Paint();
    private static Paint paint_wall = new Paint();
    private static Paint paint_cpu = new Paint();
    private static Paint paint_destroyed_cpu = new Paint();
    private static Paint paint_door = new Paint();
    private static Paint paint_side1 = new Paint();
    private static Paint paint_side2 = new Paint();
    private static Paint paint_side3 = new Paint();
    private static Paint paint_side4 = new Paint();
    private static Paint paint_direction = new Paint();
    public static int ARENA_WIDTH;
    public static int ARENA_HEIGHT;
    private static final long LOOP_DELAY = 35L;
    private static final long EVENT_DELAY = 100L;
    private static final int GETTING_GAME_DATA = 0;
    private static final int READY = 1;
    private int stage;
    private int game_id = -1;
    private int login_id = 2;
    private PlayBackGameData game_data = null;
    private GetEventDataThread event_data_thread = null;
    private int event_data_pos;
    private Interval next_event_int = new Interval(100L, false);
    private Button icon_pause;
    private Button icon_restart;
    private Button icon_ffwd;
    private Button icon_super_ffwd;
    private Button icon_rew;
    private Button icon_slowmo;
    private Button icon_play;
    private int sq_size = -1;
    private boolean paused = false;
    private boolean slowmo = false;
    private GetGameDataThreadForPlayback game_data_thread;
    private int rewind_count = 0;
    private boolean ffwd = false;
    private ArrayList<AbstractEventGraphic> graphics;
    private boolean run_to_end = false;
    private VerticalFlowLayout vfl;

    static {
        paint_text.setARGB(200, 255, 255, 255);
        paint_text.setAntiAlias(true);
        paint_text.setTextSize((float)Statics.SCREEN_WIDTH * 0.03f);
        paint_text.setTypeface(Statics.stdfnt);
        paint_smoke.setARGB(255, 200, 200, 200);
        paint_nerve_gas.setARGB(255, 0, 200, 0);
        paint_fire.setARGB(255, 255, 50, 50);
        paint_wall.setARGB(255, 0, 255, 0);
        paint_cpu.setARGB(255, 255, 0, 255);
        paint_destroyed_cpu.setARGB(255, 155, 0, 155);
        paint_door.setARGB(255, 155, 155, 155);
        paint_side1.setARGB(255, 255, 0, 0);
        paint_side1.setTextSize((float)Statics.SCREEN_WIDTH * 0.03f);
        paint_side2.setARGB(255, 255, 255, 0);
        paint_side2.setTextSize((float)Statics.SCREEN_WIDTH * 0.03f);
        paint_side3.setARGB(255, 0, 0, 255);
        paint_side3.setTextSize((float)Statics.SCREEN_WIDTH * 0.03f);
        paint_side4.setARGB(255, 0, 255, 255);
        paint_side4.setTextSize((float)Statics.SCREEN_WIDTH * 0.03f);
        paint_direction.setARGB(200, 255, 255, 255);
        paint_direction.setAntiAlias(true);
        paint_direction.setStrokeWidth(3.0f);
        ARENA_WIDTH = 650;
        ARENA_HEIGHT = 650;
    }

    public PlaybackModule(AbstractActivity act, AbstractModule return_to, int _game_id, int _login_id) {
        super(-1);
        this.mod_return_to = return_to;
        ARENA_WIDTH = Statics.SCREEN_HEIGHT;
        ARENA_HEIGHT = Statics.SCREEN_HEIGHT;
        this.game_id = _game_id;
        this.login_id = _login_id;
        this.vfl = new VerticalFlowLayout("vfl", 5.0f);
        BufferedImage bmp = Statics.img_cache.getImage("button_blue", Statics.SCREEN_WIDTH - ARENA_WIDTH, Statics.SCREEN_HEIGHT / 8);
        this.icon_restart = new Button("Restart", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_restart);
        this.icon_rew = new Button("Rewind", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_rew);
        this.icon_pause = new Button("Pause", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_pause);
        this.icon_play = new Button("Play", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_play);
        this.icon_slowmo = new Button("SlowMo", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_slowmo);
        this.icon_ffwd = new Button("Ffwd", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_ffwd);
        this.icon_super_ffwd = new Button("To End", null, paint_text, bmp);
        this.vfl.attachChild(this.icon_super_ffwd);
        this.vfl.setLocation(ARENA_WIDTH, 0.0f);
        Thread t = new Thread((Runnable)this, "PlaybackModule");
        t.start();
    }

    private void startFromBeginning() {
        AbstractActivity act = Statics.act;
        this.stage = 0;
        this.event_data_pos = 0;
        this.graphics = new ArrayList();
        this.game_data_thread = new GetGameDataThreadForPlayback(act, this.game_id);
        this.vfl.removeFromParent();
    }

    @Override
    public void run() {
        this.startFromBeginning();
        try {
            boolean stop_now = false;
            while (!stop_now) {
                AbstractActivity act = Statics.act;
                long start = System.currentTimeMillis();
                if (this.stage == 0) {
                    if (this.game_data_thread != null && !this.game_data_thread.isAlive()) {
                        this.game_data = this.game_data_thread.game_data;
                        this.game_data_thread = null;
                        if (this.game_data != null) {
                            this.sq_size = ARENA_WIDTH / this.game_data.map_width;
                            this.event_data_thread = new GetEventDataThread(act, this.game_id, this.login_id, this.game_data.max_turns);
                            this.stage = 1;
                            if (this.vfl.parent == null) {
                                this.stat_node.attachChild(this.vfl);
                                this.stat_node.updateGeometricState();
                            }
                        }
                    }
                } else if (!this.paused && this.event_data_thread != null && (this.next_event_int.hitInterval() || this.ffwd || this.rewind_count > 0)) {
                    if (this.rewind_count > 0) {
                        --this.rewind_count;
                    }
                    while (this.event_data_pos < this.event_data_thread.al_event_data.size()) {
                        PlaybackTurnData turn_data = this.event_data_thread.al_event_data.get(this.event_data_pos);
                        boolean did_something_happen = this.processEvent(turn_data);
                        if (did_something_happen) break;
                        this.nextEvent();
                    }
                    if (this.event_data_pos >= this.event_data_thread.al_event_data.size()) {
                        this.run_to_end = false;
                    }
                    this.updateGraphics();
                    this.nextEvent();
                }
                if (!this.run_to_end) {
                    long wait = 35L - System.currentTimeMillis() + start;
                    Functions.delay(wait);
                    continue;
                }
                Thread.yield();
            }
        }
        catch (Exception e) {
            AbstractActivity.HandleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGraphics() {
        ArrayList<AbstractEventGraphic> arrayList = this.graphics;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.graphics.size()) {
                AbstractEventGraphic current_event_graphic = this.graphics.get(i);
                --current_event_graphic.timer;
                if (current_event_graphic.timer <= 0) {
                    this.graphics.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    private void nextEvent() {
        if (this.rewind_count > 0 && this.event_data_pos > 0) {
            --this.event_data_pos;
        } else if (this.event_data_pos < this.event_data_thread.al_event_data.size()) {
            ++this.event_data_pos;
        }
    }

    private void setSlowMo(boolean b) {
        this.slowmo = b;
        if (this.slowmo) {
            this.next_event_int.setInterval(500L, true);
        } else {
            this.next_event_int.setInterval(100L, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processEvent(PlaybackTurnData turn_data) {
        try {
            UnitData unit = null;
            switch (turn_data.event_type) {
                case 1: {
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    unit.angle = turn_data.angle;
                    unit.setStatus((byte)2);
                    return true;
                }
                case 2: {
                    this.graphics.add(new ExplosionGraphic(turn_data.mapx * this.sq_size, turn_data.mapy * this.sq_size, turn_data.rad * this.sq_size));
                    return true;
                }
                case 3: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].destroyed = 1;
                    return false;
                }
                case 4: {
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    unit.angle = turn_data.angle;
                    if (this.rewind_count <= 1) {
                        unit.setStatus((byte)3);
                        this.graphics.add(new UnitKilledGraphic(turn_data.mapx * this.sq_size, turn_data.mapy * this.sq_size, this.sq_size));
                        return true;
                    }
                    unit.setStatus((byte)2);
                    return true;
                }
                case 5: {
                    int length;
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    int ang = turn_data.angle;
                    if (ang == 0) {
                        ang = unit.angle;
                    }
                    if ((length = turn_data.rad) == 0) {
                        length = 2;
                    }
                    this.graphics.add(new ShootingGraphic(turn_data.mapx * this.sq_size + this.sq_size / 2, turn_data.mapy * this.sq_size + this.sq_size / 2, ang, length *= this.sq_size));
                    return true;
                }
                case 19: {
                    int length;
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    int ang = turn_data.angle;
                    if (ang == 0) {
                        ang = unit.angle;
                    }
                    if ((length = turn_data.rad) == 0) {
                        length = 2;
                    }
                    if (length < 60) {
                        length *= this.sq_size;
                    }
                    this.graphics.add(new ThrowingGraphic(turn_data.mapx * this.sq_size + this.sq_size / 2, turn_data.mapy * this.sq_size + this.sq_size / 2, ang, length));
                    return true;
                }
                case 6: {
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    unit.angle = turn_data.angle;
                    unit.setStatus((byte)2);
                    return true;
                }
                case 7: {
                    unit = UnitData.GetUnitDataFromID(this.game_data.units, turn_data.unit_id);
                    if (this.rewind_count <= 1) {
                        unit.setStatus((byte)4);
                        return true;
                    }
                    unit.map_x = turn_data.mapx;
                    unit.map_y = turn_data.mapy;
                    unit.angle = turn_data.angle;
                    unit.setStatus((byte)2);
                    return true;
                }
                case 10: {
                    if (this.rewind_count <= 1) {
                        this.game_data.map[turn_data.mapx][turn_data.mapy].destroyed = 1;
                        return true;
                    }
                    this.game_data.map[turn_data.mapx][turn_data.mapy].destroyed = 0;
                    return true;
                }
                case 11: {
                    return false;
                }
                case 24: {
                    return false;
                }
                case 25: {
                    return false;
                }
                case 26: {
                    return false;
                }
                case 27: {
                    return false;
                }
                case 28: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)21;
                    return false;
                }
                case 29: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)-1;
                    return false;
                }
                case 30: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)22;
                    return false;
                }
                case 31: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)-1;
                    return false;
                }
                case 34: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)34;
                    return false;
                }
                case 35: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].smoke_type = (byte)-1;
                    return false;
                }
                case 33: {
                    this.game_data.map[turn_data.mapx][turn_data.mapy].major_type = turn_data.rad;
                    return true;
                }
            }
            System.err.println("Unknown event type: " + turn_data.event_type);
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDraw(Canvas c, long interpol) {
        super.doDraw(c, interpol);
        if (this.stage == 0) {
            c.drawText("Please wait - getting game data...", 10.0f, paint_text.getTextSize(), paint_text);
        } else {
            if (!this.run_to_end) {
                this.drawMap(c);
                this.drawUnits(c);
                ArrayList<AbstractEventGraphic> arrayList = this.graphics;
                synchronized (arrayList) {
                    int i = 0;
                    while (i < this.graphics.size()) {
                        AbstractEventGraphic current_event_graphic = this.graphics.get(i);
                        current_event_graphic.doDraw(c);
                        ++i;
                    }
                }
            }
            if (this.event_data_thread.al_event_data.size() < this.game_data.max_events) {
                c.drawText("Events downloaded: " + this.event_data_thread.al_event_data.size() + "/" + this.game_data.max_events, 10.0f, paint_text.getTextSize(), paint_text);
            }
            if (this.paused) {
                c.drawText("PAUSED", 10.0f, paint_text.getTextSize() * 4.0f, paint_text);
            } else if (this.event_data_pos >= this.event_data_thread.al_event_data.size() && this.event_data_thread.al_event_data.size() > 0) {
                c.drawText("THE END", 10.0f, paint_text.getTextSize() * 4.0f, paint_text);
            } else {
                c.drawText("Now showing event " + this.event_data_pos + "/" + this.event_data_thread.al_event_data.size(), 10.0f, paint_text.getTextSize() * 2.0f, paint_text);
            }
            try {
                if (this.game_data.player_names != null) {
                    if (this.game_data.total_sides >= 1) {
                        c.drawText(this.game_data.player_names[1], 10.0f, (float)Statics.SCREEN_HEIGHT - paint_side1.getTextSize(), paint_side1);
                    }
                    if (this.game_data.total_sides >= 2) {
                        c.drawText(this.game_data.player_names[2], Statics.SCREEN_WIDTH / 4, (float)Statics.SCREEN_HEIGHT - paint_side1.getTextSize(), paint_side2);
                    }
                    if (this.game_data.total_sides >= 3) {
                        c.drawText(this.game_data.player_names[3], Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT - paint_side1.getTextSize(), paint_side3);
                    }
                    if (this.game_data.total_sides >= 4) {
                        c.drawText(this.game_data.player_names[4], (float)Statics.SCREEN_WIDTH * 0.75f, (float)Statics.SCREEN_HEIGHT - paint_side1.getTextSize(), paint_side4);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void drawMap(Canvas c) {
        int size = this.game_data.map.length;
        RectF r = new RectF();
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                r.set(x * this.sq_size, y * this.sq_size, (x + 1) * this.sq_size, (y + 1) * this.sq_size);
                if (this.game_data.map[x][y].smoke_type == 21) {
                    c.drawRect(r, paint_smoke);
                } else if (this.game_data.map[x][y].smoke_type == 22) {
                    c.drawRect(r, paint_nerve_gas);
                } else if (this.game_data.map[x][y].smoke_type == 34) {
                    c.drawRect(r, paint_fire);
                }
                if (this.game_data.map[x][y].major_type == 3) {
                    if (this.game_data.map[x][y].destroyed == 0) {
                        c.drawRect(r, paint_wall);
                    }
                } else if (this.game_data.map[x][y].major_type != 0) {
                    if (this.game_data.map[x][y].major_type == 2) {
                        if (this.game_data.map[x][y].destroyed == 0) {
                            c.drawRect(r, paint_cpu);
                        } else {
                            c.drawRect(r, paint_destroyed_cpu);
                        }
                    } else if (this.game_data.map[x][y].door_type > 0) {
                        c.drawRect(r, paint_door);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void drawUnits(Canvas c) {
        RectF r = new RectF();
        int i = 0;
        while (i < this.game_data.units.length) {
            UnitData unit = this.game_data.units[i];
            float extra = 0.0f;
            if (unit.model_type == 7 || unit.model_type == 4) {
                extra = (float)this.sq_size * 0.5f;
            }
            r.set((float)(unit.map_x * this.sq_size) - extra, (float)(unit.map_y * this.sq_size) - extra, (float)((unit.map_x + 1) * this.sq_size) + extra, (float)((unit.map_y + 1) * this.sq_size) + extra);
            Paint p = this.getPaintForSide(unit.getSide());
            if (unit.getStatus() != 3 && unit.getStatus() == 2) {
                c.drawOval(r, p);
                int sx = unit.map_x * this.sq_size + this.sq_size / 2;
                int sy = unit.map_y * this.sq_size + this.sq_size / 2;
                c.drawLine(sx, sy, sx + PlaybackModule.GetXOffSetFromAngle(unit.angle, this.sq_size), sy + PlaybackModule.GetYOffSetFromAngle(unit.angle, this.sq_size), paint_direction);
            }
            ++i;
        }
    }

    public static int GetXOffSetFromAngle(int ang, int sq_size) {
        switch (ang) {
            case 90: {
                return 0;
            }
            case 135: {
                return -sq_size;
            }
            case 180: {
                return -sq_size;
            }
            case 225: {
                return -sq_size;
            }
            case 270: {
                return 0;
            }
            case 315: {
                return sq_size;
            }
            case 0: {
                return sq_size;
            }
            case 45: {
                return sq_size;
            }
        }
        System.err.println("Unknown angle: " + ang);
        return 0;
    }

    public static int GetYOffSetFromAngle(int ang, int sq_size) {
        switch (ang) {
            case 90: {
                return sq_size;
            }
            case 135: {
                return sq_size;
            }
            case 180: {
                return 0;
            }
            case 225: {
                return -sq_size;
            }
            case 270: {
                return -sq_size;
            }
            case 315: {
                return -sq_size;
            }
            case 0: {
                return 0;
            }
            case 45: {
                return sq_size;
            }
        }
        System.err.println("Unknown angle: " + ang);
        return 0;
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        if (c == this.icon_pause) {
            this.paused = true;
            this.run_to_end = false;
        } else if (c == this.icon_play) {
            this.paused = false;
            this.rewind_count = 0;
            this.ffwd = false;
            this.run_to_end = false;
            this.setSlowMo(false);
        } else if (c == this.icon_restart) {
            this.startFromBeginning();
            this.paused = false;
            this.run_to_end = false;
        } else if (c == this.icon_ffwd) {
            this.ffwd = true;
            this.rewind_count = 0;
            this.paused = false;
            this.setSlowMo(false);
            this.run_to_end = false;
        } else if (c == this.icon_super_ffwd) {
            this.ffwd = true;
            this.rewind_count = 0;
            this.paused = false;
            this.setSlowMo(false);
            this.run_to_end = true;
        } else if (c == this.icon_rew) {
            this.rewind_count = 20;
            this.ffwd = false;
            this.paused = false;
            this.setSlowMo(false);
            this.run_to_end = false;
        } else if (c == this.icon_slowmo) {
            this.paused = false;
            this.setSlowMo(!this.slowmo);
            this.run_to_end = false;
        }
    }

    private Paint getPaintForSide(int side) {
        switch (side) {
            case 1: {
                return paint_side1;
            }
            case 2: {
                return paint_side2;
            }
            case 3: {
                return paint_side3;
            }
            case 4: {
                return paint_side4;
            }
        }
        throw new RuntimeException("Unknown side: " + side);
    }
}

