/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.ErrorModule;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import java.net.ConnectException;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.ErrorReporter;
import ssmith.android.framework.modules.AbstractPleaseWaitModule;
import ssmith.android.framework.modules.ConfirmModule;

public class QuickstartModule
extends AbstractPleaseWaitModule {
    private static final String CONFIRM_QUICKSTART = "quickstart";

    public QuickstartModule(AbstractActivity act) {
        super(act, 0);
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        if (Statics.data.containsKey(CONFIRM_QUICKSTART)) {
            if (Statics.data.get(CONFIRM_QUICKSTART).equalsIgnoreCase("yes")) {
                super.displayMessage("Connecting to server to register user and start new mission...");
                this.start();
            } else {
                this.getMainThread().setNextModule(Statics.GetModule(0));
            }
            Statics.data.clear();
            return;
        }
        this.askIfQuickstart();
    }

    public void askIfQuickstart() {
        AbstractActivity act = Statics.act;
        ConfirmModule m = new ConfirmModule(act, this, "Quickstart?", "This will automatically log you in with a randomly generated username.", "space1.jpg", CONFIRM_QUICKSTART);
        this.getMainThread().setNextModule(m);
    }

    @Override
    public void run() {
        AbstractActivity act = Statics.act;
        int tries = 0;
        Throwable last_ex = null;
        while (tries < 3) {
            ++tries;
            try {
                WGet_SF wc = new WGet_SF(act, this, "cmd=autoregister");
                if (wc.getResponseCode() != 200) continue;
                String response = wc.getResponse();
                DataTable data = new DataTable(response);
                data.moveFirst();
                Statics.LAST_LOGIN = data.getString("Login");
                Statics.LAST_PWD = data.getString("Pwd");
                super.getMainThread().setNextModule(Statics.GetModule(5));
                return;
            }
            catch (ConnectException ex) {
                last_ex = ex;
            }
            catch (Exception ex) {
                ErrorReporter.getInstance().handleSilentException(ex);
                last_ex = ex;
            }
        }
        String msg = "";
        if (last_ex != null) {
            msg = last_ex.getMessage();
        }
        super.getMainThread().setNextModule(new ErrorModule(act, 4, "Failed!", "Error connecting to server.  Please re-try.  (Last error: " + msg + ")"));
    }
}

