/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.equip;

import com.scs.stellarforces.Statics;
import dsr.comms.DataTable;
import dsr.data.GameData;
import dsr.data.UnitData;
import ssmith.android.compatibility.Paint;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.ToggleButton;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;

public class ArmourSelectionControl
extends HorizontalFlowGridLayout {
    private static final float OVERALL_WIDTH = (float)Statics.SCREEN_WIDTH * 0.9f;
    private static float ARMOUR_ICON_WIDTH;
    private static float ARMOUR_ICON_HEIGHT;
    private UnitData unit;
    private static Paint paint_unit_name;
    private static Paint paint_armour_name;

    static {
        paint_unit_name = new Paint();
        paint_armour_name = new Paint();
        paint_unit_name.setARGB(255, 255, 255, 255);
        paint_unit_name.setAntiAlias(true);
        paint_armour_name.setARGB(255, 255, 255, 255);
        paint_armour_name.setAntiAlias(true);
    }

    public ArmourSelectionControl(UnitData _unit, DataTable armour_dt, float GAP, GameData game_data) {
        super("UnitArmourSelectionControl", GAP);
        paint_unit_name.setTypeface(Statics.stdfnt);
        paint_armour_name.setTypeface(Statics.stdfnt);
        ARMOUR_ICON_WIDTH = OVERALL_WIDTH * 0.6f / (float)(armour_dt.size() + 1);
        ARMOUR_ICON_HEIGHT = ARMOUR_ICON_WIDTH * 0.9f;
        this.unit = _unit;
        Label l = new Label("Unit_name", this.unit.name, null, paint_unit_name, false);
        l.setSize(OVERALL_WIDTH * 0.4f, ARMOUR_ICON_HEIGHT);
        l.collides = true;
        this.attachChild(l);
        ToggleButton b = new ToggleButton("0", "None", null, null, paint_armour_name, Statics.img_cache.getImage("button_blue", ARMOUR_ICON_WIDTH, ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", ARMOUR_ICON_WIDTH, ARMOUR_ICON_HEIGHT));
        this.attachChild(b);
        b.setSelected(this.unit.protection == 0);
        armour_dt.moveBeforeFirst();
        while (armour_dt.moveNext()) {
            if (game_data.getMaxProtectionForOurSide() >= 0 && armour_dt.getInt("Protection") > game_data.getMaxProtectionForOurSide()) continue;
            String name = String.valueOf(armour_dt.getString("Name").trim().replace("-", "\n")) + "\n" + armour_dt.getInt("Cost");
            b = new ToggleButton(armour_dt.getString("ArmourTypeID"), name, null, null, paint_armour_name, Statics.img_cache.getImage("button_blue", ARMOUR_ICON_WIDTH, ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", ARMOUR_ICON_WIDTH, ARMOUR_ICON_HEIGHT));
            b.setSelected(this.unit.armour_type_id == armour_dt.getInt("ArmourTypeID"));
            this.attachChild(b);
        }
        this.updateGeometricState();
    }

    public void selectArmour(AbstractComponent c) {
        for (Spatial s : this.getChildren()) {
            ToggleButton t;
            if (!(s instanceof ToggleButton)) continue;
            t.setSelected(c == (t = (ToggleButton)s));
            if (c != t) continue;
            this.unit.armour_type_id = Short.parseShort(t.getActionCommand());
        }
    }
}

