/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.equip;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.AllUnitStatsModule;
import com.scs.stellarforces.start.CurrentGameDetailsModule;
import com.scs.stellarforces.start.GetGameDataModule;
import com.scs.stellarforces.start.equip.EquipHelpModule;
import com.scs.stellarforces.start.equip.EquipUnitControl;
import com.scs.stellarforces.start.equip.EquipmentStatsModule;
import com.scs.stellarforces.start.equip.GetEquipmentDataModule;
import com.scs.stellarforces.start.equip.SelectArmourModule;
import com.scs.stellarforces.start.equip.SellItemModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.EquipmentDataComms;
import dsr.comms.GameDataComms;
import dsr.comms.WGet_SF;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.UnitData;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.ErrorReporter;
import ssmith.android.framework.modules.ConfirmModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineButton;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.android.lib2d.shapes.Rectangle;
import ssmith.util.Browser;

public class EquipUnitsModule3
extends SimpleScrollingAbstractModule {
    private static final float WIDTH = (float)Statics.SCREEN_WIDTH * 0.19f;
    private static final float HEIGHT = (float)Statics.SCREEN_HEIGHT * 0.13f;
    private static final float GAP = (float)Statics.SCREEN_WIDTH * 0.01f;
    private static final String CONFIRM_END = "finish_equipping";
    private static final String CMD_ITEM_INFO = "item_info";
    private GameData game_data;
    private DataTable equipment_dt;
    private DataTable armour_dt;
    private MultiLineButton item_name;
    private Button help;
    private Button next_item;
    private Button prev_item;
    private Button stats;
    private int creds_remaining;
    private ArrayList<UnitData> units;
    private Button grenades;
    private Button guns;
    private Button melee;
    private Button other_equip;
    private Button finished;
    private Button armour;
    private Button game_details;
    private Button mission_file;
    private int num_units;
    private AllUnitStatsModule stats_mod;
    private boolean any_units = false;
    private Label creds_left;
    private static Paint paint_unit_name = new Paint();
    private static Paint paint_normal_text = new Paint();
    private static Paint paint_equip_text = new Paint();
    private static Paint paint_black_fill = new Paint();

    static {
        paint_unit_name.setARGB(255, 255, 255, 255);
        paint_unit_name.setTypeface(Statics.stdfnt);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setTypeface(Statics.stdfnt);
        paint_equip_text.setARGB(255, 255, 255, 255);
        paint_equip_text.setTypeface(Statics.stdfnt);
        paint_black_fill.setARGB(155, 0, 0, 0);
    }

    public EquipUnitsModule3(AbstractActivity act, SelectArmourModule sa_mod, GameData _gamedata, ArrayList<UnitData> _units, DataTable _armour, DataTable _eq, int _num_units) {
        super(-1);
        this.limit_dragging = false;
        this.mod_return_to = sa_mod;
        this.game_data = _gamedata;
        this.equipment_dt = _eq;
        this.armour_dt = _armour;
        this.units = _units;
        this.num_units = _num_units;
        this.setBackground("space1.jpg");
        this.root_node.removeAllChildren();
        this.stat_node.removeAllChildren();
        Rectangle back = new Rectangle("back", 0.0f, 0.0f, Statics.SCREEN_WIDTH, HEIGHT * 2.0f, paint_black_fill, null);
        this.stat_node.attachChild(back);
        VerticalFlowLayout vfl_header = new VerticalFlowLayout("vfl", GAP);
        HorizontalFlowGridLayout hfgl0 = new HorizontalFlowGridLayout("hfgl0", GAP);
        this.help = new Button("Help", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH * 0.75f, HEIGHT));
        hfgl0.attachChild(this.help);
        this.creds_left = new Label("creds_left", "Filled in later..", paint_black_fill, paint_unit_name, false);
        hfgl0.attachChild(this.creds_left);
        vfl_header.attachChild(hfgl0);
        GridLayout hfgl4 = new GridLayout("hfgl4", WIDTH, HEIGHT, GAP);
        this.prev_item = new Button("", paint_black_fill, paint_normal_text, Statics.img_cache.getImage("big_arrow_left", WIDTH, HEIGHT));
        hfgl4.attachChild(this.prev_item, 0, 0);
        this.item_name = new MultiLineButton("item_name", CMD_ITEM_INFO, "", paint_black_fill, paint_equip_text, true, (float)Statics.SCREEN_WIDTH - WIDTH * 2.0f, false);
        this.item_name.setCollides(true);
        hfgl4.attachChild(this.item_name, 1, 0);
        this.next_item = new Button("", paint_black_fill, paint_normal_text, Statics.img_cache.getImage("big_arrow_right", WIDTH, HEIGHT));
        hfgl4.attachChild(this.next_item, 4, 0);
        vfl_header.attachChild(hfgl4);
        this.stat_node.attachChild(vfl_header);
        GridLayout hfl_footer = new GridLayout("footer", WIDTH, HEIGHT, GAP);
        hfl_footer.setLocation(0.0f, (float)Statics.SCREEN_HEIGHT - HEIGHT);
        this.stats = new Button("Unit\nStats", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH, HEIGHT));
        hfl_footer.attachChild(this.stats, 0, 0);
        this.armour = new Button("Return to\nArmour", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH, HEIGHT));
        hfl_footer.attachChild(this.armour, 1, 0);
        this.game_details = new Button("Game\nDetails", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH, HEIGHT));
        hfl_footer.attachChild(this.game_details, 2, 0);
        this.mission_file = new Button("Mission\nFile", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH, HEIGHT));
        hfl_footer.attachChild(this.mission_file, 3, 0);
        this.finished = new Button("Finished!", null, paint_normal_text, Statics.img_cache.getImage("button_red", WIDTH, HEIGHT));
        hfl_footer.attachChild(this.finished, 4, 0);
        this.stat_node.attachChild(hfl_footer);
        VerticalFlowLayout vfl_units = new VerticalFlowLayout("vfl", GAP);
        for (UnitData unit : this.units) {
            if (unit.getSide() != this.game_data.our_side || !unit.can_use_equipment || unit.can_deploy <= 0 || unit.can_equip <= 0) continue;
            this.any_units = true;
            EquipUnitControl ctrl = new EquipUnitControl(this, unit, GAP, this.game_data, paint_unit_name.getTypeface());
            vfl_units.attachChild(ctrl);
        }
        this.root_node.attachChild(vfl_units);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, (float)(Statics.SCREEN_HEIGHT / 2) - HEIGHT * 2.0f, true);
        if (!this.any_units) {
            this.finish();
        }
        this.updateCredsLeft();
        this.equipment_dt.moveFirst();
        this.showItem();
        this.showToast("Equip Your Units!");
    }

    @Override
    public void started() {
        if (!this.any_units || this.game_data.creds <= 0) {
            this.finish();
            return;
        }
        if (Statics.data.containsKey(CONFIRM_END)) {
            String s = Statics.data.get(CONFIRM_END);
            Statics.data.clear();
            if (s.equalsIgnoreCase("yes")) {
                this.finish();
            }
        }
        this.updateCredsLeft();
        this.showItem();
    }

    private void updateCredsLeft() {
        this.creds_remaining = GetEquipmentDataModule.GetCredsRemaining(this.game_data, this.units, this.armour_dt, this.equipment_dt);
        int avg_each = 0;
        if (this.num_units > 0) {
            avg_each = this.creds_remaining / this.num_units;
        }
        this.creds_left.setText("Equip Units - Creds Left:" + this.creds_remaining + " (" + avg_each + " each)");
    }

    private void showItem() {
        StringBuffer str = new StringBuffer();
        str.append("Currently Viewing " + this.equipment_dt.getString("MajorType") + ":-\n" + this.equipment_dt.getString("name") + " (" + this.equipment_dt.getString("cost") + " creds)\n");
        try {
            switch (this.equipment_dt.getInt("MajorTypeID")) {
                case 1: {
                    str.append("Acc: " + this.equipment_dt.getInt("AimedShotAccuracy") + "%, Damage: " + this.equipment_dt.getInt("ShotDamage"));
                    this.equipment_dt.pushRow();
                    if (this.equipment_dt.find("MajorTypeID", "5", "AmmoTypeID", "" + this.equipment_dt.getInt("AmmoTypeID"))) {
                        str.append(", Uses " + this.equipment_dt.getString("Name") + " ammo");
                    }
                    this.equipment_dt.popRow();
                    break;
                }
                case 2: {
                    str.append("Explosion Range: " + this.equipment_dt.getInt("ExplosionRad") + ", Damage: " + this.equipment_dt.getInt("ExplosionDamage"));
                    break;
                }
                case 4: {
                    str.append("CC Damage: " + this.equipment_dt.getInt("CCDamage"));
                    break;
                }
                case 5: {
                    str.append(this.equipment_dt.getString("Description"));
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.item_name.setText(str.toString());
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c == this.help) {
            EquipHelpModule mod = new EquipHelpModule(act, this);
            this.getMainThread().setNextModule(mod);
        } else if (c == this.guns) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.moveNext()) continue;
                this.equipment_dt.moveFirst();
                --count;
            } while (this.equipment_dt.getInt("MajorTypeID") != 1 && count > 0);
            this.showItem();
        } else if (c == this.grenades) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.moveNext()) continue;
                this.equipment_dt.moveFirst();
                --count;
            } while ((this.equipment_dt.getInt("MajorTypeID") != 2 || this.equipment_dt.getInt("MajorTypeID") != 21 || this.equipment_dt.getInt("MajorTypeID") != 22 || this.equipment_dt.getInt("MajorTypeID") != 9) && count > 0);
            this.showItem();
        } else if (c == this.melee) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.moveNext()) continue;
                this.equipment_dt.moveFirst();
                --count;
            } while (this.equipment_dt.getInt("MajorTypeID") != 4 && count > 0);
            this.showItem();
        } else if (c == this.other_equip) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.moveNext()) continue;
                this.equipment_dt.moveFirst();
                --count;
            } while (this.equipment_dt.getInt("MajorTypeID") != 3 && count > 0);
            this.showItem();
        } else if (c == this.next_item) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.moveNext()) continue;
                this.equipment_dt.moveFirst();
                --count;
            } while (this.equipment_dt.getInt("Cost") > this.creds_remaining && count > 0 && this.creds_remaining > 0);
            this.showItem();
        } else if (c == this.prev_item) {
            int count = this.equipment_dt.size();
            do {
                if (this.equipment_dt.movePrev()) continue;
                this.equipment_dt.moveLast();
                --count;
            } while (this.equipment_dt.getInt("Cost") > this.creds_remaining && count > 0 && this.creds_remaining > 0);
            this.showItem();
        } else if (c == this.game_details) {
            CurrentGameDetailsModule mod = new CurrentGameDetailsModule(act, this, this.game_data, true);
            this.getMainThread().setNextModule(mod);
        } else if (c == this.mission_file) {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + this.game_data.mission_type + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        } else if (c == this.armour) {
            if (this.saveEquipment()) {
                this.returnTo();
            }
        } else if (c == this.stats) {
            if (this.stats_mod == null) {
                this.stats_mod = new AllUnitStatsModule(act, this, this.game_data, this.units, null);
            }
            this.getMainThread().setNextModule(this.stats_mod);
        } else if (c.getActionCommand().equalsIgnoreCase(CMD_ITEM_INFO)) {
            this.getMainThread().setNextModule(new EquipmentStatsModule(act, this, this.equipment_dt));
        } else if (c == this.finished) {
            if (GetEquipmentDataModule.GetCredsRemaining(this.game_data, this.units, this.armour_dt, this.equipment_dt) >= 0) {
                if (this.saveEquipment()) {
                    this.confirmIfFinished();
                }
            } else {
                this.showToast("You've spent too many creds!");
            }
        } else if (c.parent.parent instanceof EquipUnitControl) {
            EquipUnitControl ctrl = (EquipUnitControl)c.parent.parent;
            ctrl.handleClick(c);
        }
    }

    private void confirmIfFinished() {
        AbstractActivity act = Statics.act;
        this.getMainThread().setNextModule(new ConfirmModule(act, this, "Are You Sure?", "Are you sure you have definitely finished equipping your units?  You can't go back afterwards!", "space1.jpg", CONFIRM_END));
    }

    private void finish() {
        AbstractActivity act = Statics.act;
        try {
            this.showPleaseWait("Saving data...");
            WGet_SF wc = new WGet_SF(act, null, GameDataComms.GetGameUpdateRequest(this.game_data.game_id, this.game_data.gamecode, this.game_data.our_side, 3));
            String response = wc.getResponse();
            this.dismissPleaseWait();
            if (!AbstractCommFuncs.IsResponseGood(response)) {
                throw new IOException("Bad response");
            }
            super.getMainThread().setNextModule(new GetGameDataModule(act, this.game_data));
        }
        catch (IOException ex) {
            this.dismissPleaseWait();
            this.showToast("Unable to save data.  Please try again.");
        }
    }

    public void buyItem(UnitData unit) {
        if (this.equipment_dt.getInt("Cost") <= this.creds_remaining) {
            EquipmentData new_eq = new EquipmentData();
            new_eq.equip_id = -1;
            new_eq.setName(this.equipment_dt.getString("Name"));
            new_eq.equipment_type_id = this.equipment_dt.getInt("EquipmentTypeID");
            new_eq.setUnitID(unit.unitid);
            new_eq.setAmmo(this.equipment_dt.getByte("AmmoCapacity"));
            GetEquipmentDataModule.AddEquipmentRec(new_eq);
            this.updateCredsLeft();
        } else {
            this.showToast("Insufficient Credits!");
        }
    }

    public void removeItem(UnitData unit, EquipUnitControl ctrl) {
        AbstractActivity act = Statics.act;
        this.getMainThread().setNextModule(new SellItemModule(act, this, unit, ctrl));
    }

    private boolean saveEquipment() throws UnknownHostException, IOException {
        AbstractActivity act = Statics.act;
        if (SelectArmourModule.bought_equipment.length > 0) {
            try {
                try {
                    this.showPleaseWait("Saving equipment...");
                    String req = "cmd=rem_equip&version=" + Statics.COMMS_VERSION + "&gid=" + this.game_data.game_id + "&gc=" + this.game_data.gamecode + "&side=" + this.game_data.our_side;
                    new WGet_SF(act, null, req);
                    StringBuffer request = new StringBuffer();
                    EquipmentData[] equipmentDataArray = SelectArmourModule.bought_equipment;
                    int n = SelectArmourModule.bought_equipment.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EquipmentData eq = equipmentDataArray[n2];
                        if (eq.getUnitID() > 0) {
                            eq.new_item = 1;
                            req = EquipmentDataComms.GetEquipmentUpdateRequest(eq, -1, -1, this.game_data.game_id);
                            request.append(String.valueOf(req) + "~");
                        }
                        ++n2;
                    }
                    new WGet_SF(act, null, request.toString());
                }
                catch (Exception ex) {
                    if (!(ex instanceof IOException)) {
                        ErrorReporter.getInstance().handleSilentException(ex);
                    }
                    this.dismissPleaseWait();
                    this.showToast(ex.toString());
                    this.dismissPleaseWait();
                    return false;
                }
            }
            finally {
                this.dismissPleaseWait();
            }
        }
        return true;
    }
}

