/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.finishedgames;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.playback.PlaybackModule;
import com.scs.stellarforces.start.GenericMessageModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import java.io.IOException;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.util.Browser;

public class FinishedGameDetailsModule
extends SimpleScrollingAbstractModule {
    private static final String CMD_WATCH_PLAYBACK = "Watch Playback";
    private static final String CMD_GAME_CHAT = "Game Chat";
    private static final String CMD_REMATCH_SAME_SIDES = "Rematch - Same Sides";
    private static final String CMD_OPPOSITE_SIDES = "Rematch - Opposite Sides";
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.4f;
    private static final float ICON_HEIGHT = (float)Statics.SCREEN_HEIGHT * 0.15f;
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();
    private DataTable dt;

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
    }

    public FinishedGameDetailsModule(AbstractActivity act, AbstractModule _return_to, DataTable _dt) {
        super(-1);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.dt = _dt;
        this.mod_return_to = _return_to;
        this.setBackground("space1.jpg");
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", (float)Statics.SCREEN_HEIGHT * 0.001f);
        Label l = new Label("Title", "Game " + this.dt.getInt("GameID") + " Summary", 0.0f, 0.0f, null, paint_large_text, true);
        l.setCentre(Statics.SCREEN_WIDTH / 2, paint_large_text.getTextSize());
        vfl.attachChild(l);
        StringBuffer str = new StringBuffer();
        str.append("Mission: " + this.dt.getString("MissionName"));
        if (this.dt.getInt("IsAdvanced") == 1) {
            str.append("\nAdvanced Mode");
        }
        str.append("\n");
        int s = 1;
        while (s <= this.dt.getInt("Sides")) {
            str.append(String.valueOf(this.dt.getString("Player" + s + "Name")) + " (" + this.dt.getString("Side" + s + "Name") + "): " + this.dt.getString("Side" + s + "VPs") + " VPs");
            str.append("\n");
            ++s;
        }
        MultiLineLabel mll = new MultiLineLabel("credits", str.toString(), null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
        mll.setLocation(10.0f, (float)Statics.SCREEN_HEIGHT * 0.15f);
        vfl.attachChild(mll);
        vfl.updateGeometricState();
        GridLayout menu_node = new GridLayout("Menu", ICON_WIDTH, ICON_HEIGHT, Statics.GetButtonSpacing());
        Button b = new Button(CMD_WATCH_PLAYBACK, CMD_WATCH_PLAYBACK, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(b, 0, 0);
        b = new Button(CMD_GAME_CHAT, CMD_GAME_CHAT, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
        menu_node.attachChild(b, 1, 0);
        if (this.dt.getInt("Sides") == 2) {
            b = new Button(CMD_REMATCH_SAME_SIDES, CMD_REMATCH_SAME_SIDES, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
            menu_node.attachChild(b, 0, 1);
            b = new Button(CMD_OPPOSITE_SIDES, CMD_OPPOSITE_SIDES, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT));
            menu_node.attachChild(b, 1, 1);
        }
        vfl.attachChild(menu_node);
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(this.root_node, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        String cmd = c.getActionCommand();
        if (cmd.equalsIgnoreCase(CMD_WATCH_PLAYBACK)) {
            this.getMainThread().setNextModule(new PlaybackModule(act, this, this.dt.getInt("GameID"), -1));
        } else if (cmd.equalsIgnoreCase(CMD_GAME_CHAT)) {
            this.showGameChat();
        } else if (cmd.equalsIgnoreCase(CMD_REMATCH_SAME_SIDES)) {
            this.createNewGame(true);
        } else if (cmd.equalsIgnoreCase(CMD_OPPOSITE_SIDES)) {
            this.createNewGame(false);
        }
    }

    private void createNewGame(boolean same_sides) {
        AbstractActivity act = Statics.act;
        try {
            WGet_SF wc;
            String response;
            String cmd = "start_new_same_sides";
            if (!same_sides) {
                cmd = "start_new_opp_sides";
            }
            if (AbstractCommFuncs.IsResponseGood(response = (wc = new WGet_SF(act, null, "cmd=" + cmd + "&gameid=" + this.dt.getInt("GameID") + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD))).getResponse())) {
                this.getMainThread().setNextModule(new GenericMessageModule(act, 2, "Game Being Created", "The new game is now in the process of being created.\n\nPress the screen to continue."));
            } else {
                this.showToast("Error creating game.");
            }
        }
        catch (IOException ex) {
            this.showToast("Error creating game: " + ex.getMessage());
        }
    }

    private void showGameChat() {
        try {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/forums/ForumPostingsPage.cls?topic=" + this.dt.getInt("ForumID") + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }
}

