/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.newgame;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.GenericMessageModule;
import com.scs.stellarforces.start.newgame.ChooseMissionModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.CheckBox;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.gui.ToggleButton;
import ssmith.android.lib2d.gui.ToggleButtonGroup;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.util.Browser;

public class StartNewGameModule
extends SimpleScrollingAbstractModule {
    private static final String YOU = "You";
    private static final String ANOTHER_PLAYER = "Another Player";
    private static final String AI = "AI";
    public static final String DATA_MISSION_NAME = "mission_name";
    public static final String DATA_OPPONENT_NAME = "opponent_name";
    private static final float ICON_HEIGHT = Statics.SCREEN_HEIGHT / 8;
    private static DataTable missions_dt;
    private String selected_mission_name = "[Press Here]";
    private Button cmd_mission;
    private Button cmd_opponent;
    private Button start_game;
    private Button cmd_show_mission;
    private CheckBox cmd_advanced;
    private CheckBox cmd_practise;
    private ToggleButtonGroup[] groups;
    private static Paint paint_large_text;
    private static Paint paint_med_text;
    private static Paint paint_normal_text;

    static {
        paint_large_text = new Paint();
        paint_med_text = new Paint();
        paint_normal_text = new Paint();
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_med_text.setARGB(255, 255, 255, 255);
        paint_med_text.setAntiAlias(true);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_large_text.setTypeface(Statics.stdfnt);
    }

    public StartNewGameModule(AbstractActivity act) {
        super(9);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_med_text.setTypeface(Statics.stdfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        block16: {
            AbstractActivity act = Statics.act;
            if (missions_dt == null || missions_dt.size() == 0) {
                this.showPleaseWait("Getting missions...");
                try {
                    try {
                        WGet_SF wc = new WGet_SF(act, null, "cmd=mission_list&free=&comms_version=" + Statics.COMMS_VERSION + "&android_version=" + 1.4f + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD));
                        String response = wc.getResponse();
                        if (response != null && response.length() > 0) {
                            missions_dt = new DataTable(response);
                            break block16;
                        }
                        throw new IOException("Got response " + wc.getResponseCode() + " from server and no data");
                    }
                    catch (Exception ex) {
                        AbstractActivity.HandleError(ex);
                        this.dismissPleaseWait();
                        return;
                    }
                }
                finally {
                    this.dismissPleaseWait();
                }
            }
        }
        if (Statics.data.containsKey(DATA_MISSION_NAME)) {
            this.selected_mission_name = Statics.data.get(DATA_MISSION_NAME);
        }
        String opponent_names = "";
        if (Statics.data.containsKey(DATA_OPPONENT_NAME)) {
            String text;
            opponent_names = text = Statics.data.get(DATA_OPPONENT_NAME).toString();
            if (this.cmd_opponent != null) {
                this.cmd_opponent.setText(text);
            }
            Statics.data.clear();
            return;
        }
        Statics.data.clear();
        this.root_node.detachAllChildren();
        Label l = new Label("Title", "Start New Game", 0.0f, 0.0f, null, paint_large_text, true);
        l.setCentre(Statics.SCREEN_WIDTH / 2, paint_large_text.getTextSize());
        this.root_node.attachChild(l);
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", (float)Statics.SCREEN_HEIGHT * 0.05f);
        vfl.setLocation(0.0f, (float)Statics.SCREEN_HEIGHT * 0.2f);
        Label mission = new Label("mission", "Choose Mission:", null, paint_med_text);
        vfl.attachChild(mission);
        this.cmd_mission = new Button(this.selected_mission_name, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.8f, ICON_HEIGHT));
        vfl.attachChild(this.cmd_mission);
        if (this.selected_mission_name.length() > 0 && missions_dt.find("Name", this.selected_mission_name)) {
            String text = "";
            try {
                text = AbstractCommFuncs.URLDecodeString(missions_dt.getString("Description"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            MultiLineLabel mll = new MultiLineLabel("Mission text", text, null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
            vfl.attachChild(mll);
            this.cmd_show_mission = new Button("View Mission Details", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.8f, ICON_HEIGHT));
            vfl.attachChild(this.cmd_show_mission);
            Label lbl_opponent = new Label("opponent", "Optional Opponent(s):", null, paint_med_text);
            vfl.attachChild(lbl_opponent);
            Label opponent2 = new Label("opponent", "(leave blank for anyone to accept)", null, paint_normal_text);
            vfl.attachChild(opponent2);
            this.cmd_opponent = new Button(opponent_names, null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.8f, ICON_HEIGHT));
            vfl.attachChild(this.cmd_opponent);
            if (this.selected_mission_name.toLowerCase().indexOf("beta") < 0) {
                this.cmd_advanced = new CheckBox("Advanced Mode?", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.8f, ICON_HEIGHT), false);
                vfl.attachChild(this.cmd_advanced);
                this.cmd_practise = new CheckBox("Practise Game?", null, paint_normal_text, Statics.img_cache.getImage("lumin_green_button2", (float)Statics.SCREEN_WIDTH * 0.8f, ICON_HEIGHT), false);
                vfl.attachChild(this.cmd_practise);
            }
            Label lbl_sides = new Label("sides", "Who should control each side?", null, paint_med_text);
            vfl.attachChild(lbl_sides);
            int sides = missions_dt.getInt("Sides");
            this.groups = new ToggleButtonGroup[sides + 1];
            int b = 0;
            while (b < sides) {
                ToggleButtonGroup grp;
                l = new Label("side1", "Side " + (b + 1) + " - " + missions_dt.getString("Side" + (b + 1) + "Name") + ":", null, paint_normal_text);
                vfl.attachChild(l);
                HorizontalFlowGridLayout hfl = new HorizontalFlowGridLayout("hfl", (float)Statics.SCREEN_WIDTH * 0.05f);
                this.groups[b + 1] = grp = new ToggleButtonGroup();
                ToggleButton you = new ToggleButton(YOU, YOU, null, null, paint_normal_text, Statics.img_cache.getImage("button_blue", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT));
                you.setGroup(grp);
                hfl.attachChild(you);
                ToggleButton opponent = new ToggleButton(ANOTHER_PLAYER, ANOTHER_PLAYER, null, null, paint_normal_text, Statics.img_cache.getImage("button_blue", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT));
                opponent.setGroup(grp);
                hfl.attachChild(opponent);
                if (missions_dt.getInt("AIForSide" + (b + 1)) == 1) {
                    ToggleButton ai = new ToggleButton(AI, AI, null, null, paint_normal_text, Statics.img_cache.getImage("button_blue", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", (float)Statics.SCREEN_WIDTH * 0.25f, ICON_HEIGHT));
                    ai.setGroup(grp);
                    hfl.attachChild(ai);
                }
                vfl.attachChild(hfl);
                ++b;
            }
            this.start_game = new Button("start_game", "Start Game!", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH * 0.9f, ICON_HEIGHT));
            vfl.attachChild(this.start_game);
        }
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c == this.cmd_mission) {
            this.getMainThread().setNextModule(new ChooseMissionModule(act, this, missions_dt));
            return;
        }
        if (c == this.cmd_show_mission) {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + missions_dt.getInt("MissionID") + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
            return;
        }
        if (c == this.cmd_opponent) {
            inputComponent = this.cmd_opponent;
            return;
        }
        if (c == this.cmd_advanced) {
            this.cmd_advanced.toggle();
            return;
        }
        if (c == this.cmd_practise) {
            this.cmd_practise.toggle();
            return;
        }
        if (c instanceof ToggleButton) {
            ToggleButton tb = (ToggleButton)c;
            tb.toggeSelected();
            return;
        }
        if (c != this.start_game) return;
        int sides = missions_dt.getInt("Sides");
        int our_side = -1;
        int ai_side = -1;
        int b = 1;
        while (b <= sides) {
            ToggleButtonGroup grp = this.groups[b];
            ToggleButton tb = grp.getSelected();
            if (tb == null) {
                this.showToast("No option selected for side " + b);
                return;
            }
            if (tb.getActionCommand().equals(YOU)) {
                if (our_side >= 0) {
                    this.showToast("Only choose one side!");
                    return;
                }
                our_side = b;
            } else if (!tb.getActionCommand().equals(ANOTHER_PLAYER) && tb.getActionCommand().equals(AI)) {
                ai_side = b;
            }
            ++b;
        }
        if (our_side > 0) {
            this.createNewGame(our_side, ai_side);
            return;
        }
        this.showToast("No side selected for yourself!");
    }

    private void createNewGame(int our_side, int ai_side) {
        AbstractActivity act = Statics.act;
        this.showPleaseWait("Creating game...");
        try {
            WGet_SF wc;
            String response;
            int advanced = 0;
            if (this.cmd_advanced != null && this.cmd_advanced.isChecked()) {
                advanced = 1;
            }
            int practise = 0;
            if (this.cmd_practise != null && this.cmd_practise.isChecked()) {
                practise = 1;
            }
            if (this.selected_mission_name.toLowerCase().indexOf("beta") > 0) {
                advanced = 0;
                practise = 1;
            }
            if ((response = (wc = new WGet_SF(act, null, "cmd=create_game&version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&missionid=" + missions_dt.getInt("MissionID") + "&opponent=" + AbstractCommFuncs.URLEncodeString(this.cmd_opponent.getText()) + "&side=" + our_side + "&advanced=" + advanced + "&practise=" + practise + "&aiside=" + ai_side)).getResponse()).length() == 0 || response.equalsIgnoreCase("ok")) {
                this.getMainThread().setNextModule(new GenericMessageModule(act, 2, "Game Being Created", "Your chosen game is now in the process of being created.  If you are not playing against the AI, you will receive an email when another player joins your game.\n\nPress the screen to continue."));
            } else {
                this.dismissPleaseWait();
                this.showToast(response);
            }
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
            this.dismissPleaseWait();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode) {
        if (resultCode == 1) {
            this.started();
        }
    }
}

