/*
 * Decompiled with CFR 0.152.
 */
package dsr.comms;

import com.scs.stellarforces.Statics;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.EquipmentDataComms;
import dsr.comms.MapDataComms;
import dsr.comms.UnitDataComms;
import dsr.comms.WGet_SF;
import dsr.data.ClientMapData;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.UnitData;
import java.io.IOException;
import java.util.ArrayList;
import ssmith.android.framework.AbstractActivity;
import ssmith.util.IDisplayMessages;

public final class GetAllGameData
extends Thread {
    private ClientMapData mapdata;
    public ArrayList<UnitData> units;
    public GameData game_data;
    public EquipmentData[] equipment;
    private IDisplayMessages id;
    private boolean success = false;
    private AbstractActivity act;

    public GetAllGameData(AbstractActivity _act, GameData _game_data, boolean thread, IDisplayMessages _id) throws IOException {
        super("GetAllGameData");
        this.act = _act;
        this.game_data = _game_data;
        this.id = _id;
        if (thread) {
            this.setDaemon(true);
            this.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            this.getMapData();
            this.getUnitData();
            this.getEquipmentData();
            this.getSeenEnemies();
            this.getHeardEnemies();
            this.success = true;
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }

    private void getMapData() throws Exception {
        int retries = 3;
        while (true) {
            --retries;
            this.writeText("Transporting to mission location...");
            WGet_SF wc = new WGet_SF(this.act, this.id, MapDataComms.GetMapDataRequest(this.game_data.game_id));
            if (wc.getResponseCode() == 200) {
                String response = wc.getResponse();
                try {
                    this.mapdata = MapDataComms.DecodeMapDataResponse(response);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (retries <= 0) {
                throw new RuntimeException("Error getting map data!");
            }
            this.writeText("Problem getting map data - retrying...");
        }
        this.writeText("Journey complete.");
    }

    private void getUnitData() throws IOException {
        int retries = 3;
        while (true) {
            --retries;
            this.writeText("Units awaking from hypersleep...");
            WGet_SF wc = new WGet_SF(this.act, this.id, UnitDataComms.GetUnitDataRequest(this.game_data.game_id, this.game_data.gamecode, Statics.LAST_LOGIN, Statics.LAST_PWD));
            if (wc.getResponseCode() == 200) {
                String response = wc.getResponse();
                try {
                    this.units = UnitDataComms.DecodeUnitDataResponse(response);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (retries <= 0) {
                throw new RuntimeException("Error getting unit data!");
            }
            this.writeText("Problem getting map data - retrying...");
        }
        this.writeText("All units ready.");
    }

    private void getEquipmentData() throws IOException {
        int retries = 3;
        while (true) {
            --retries;
            this.writeText("Units are checking their equipment...");
            WGet_SF wc = new WGet_SF(this.act, this.id, EquipmentDataComms.GetEquipmentDataRequest(this.game_data.game_id, this.game_data.gamecode));
            if (wc.getResponseCode() == 200) {
                String response = wc.getResponse();
                try {
                    this.equipment = EquipmentDataComms.DecodeEquipmentDataResponse(this.mapdata, this.units, response);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (retries <= 0) {
                throw new RuntimeException("Error getting equipment data!");
            }
            this.writeText("Problem getting equipment data - retrying...");
        }
        this.writeText("All equipment okay.");
    }

    private void getSeenEnemies() throws IOException {
        int retries = 3;
        while (true) {
            --retries;
            this.writeText("Getting intelligence data...");
            WGet_SF wc = new WGet_SF(this.act, this.id, "cmd=seen_enemy_data&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gameid=" + this.game_data.game_id);
            if (wc.getResponseCode() == 200) {
                String response = wc.getResponse();
                try {
                    this.game_data.seen_enemies = new DataTable(response);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (retries <= 0) {
                throw new RuntimeException("Error getting intelligence data!");
            }
            this.writeText("Problem getting intelligence data - retrying...");
        }
        this.writeText("Got intelligence data");
    }

    private void getHeardEnemies() throws IOException {
        int retries = 3;
        while (true) {
            --retries;
            this.writeText("Getting more intelligence data...");
            WGet_SF wc = new WGet_SF(this.act, this.id, "cmd=heard_enemy_data&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gameid=" + this.game_data.game_id);
            if (wc.getResponseCode() == 200) {
                String response = wc.getResponse();
                try {
                    this.game_data.heard_enemies = new DataTable(response);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (retries <= 0) {
                throw new RuntimeException("Error getting more intelligence data!");
            }
            this.writeText("Problem getting more intelligence data - retrying...");
        }
        this.writeText("Got more intelligence data");
    }

    public ClientMapData getMap() {
        return this.mapdata;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    private void writeText(String s) {
        if (this.id != null) {
            this.id.displayMessage(s);
        }
    }
}

