/*
 * Decompiled with CFR 0.152.
 */
package dsr.comms;

import com.scs.stellarforces.Statics;
import dsr.comms.AbstractCommFuncs;
import dsr.data.UnitData;
import java.io.IOException;
import java.util.ArrayList;
import ssmith.lang.NumberFunctions;

public final class UnitDataComms {
    public static final int HEAR_ENEMY_DISTANCE = 3;
    public static final int HEAR_DOOR_DISTANCE = 3;
    public static final int QUEEN_ALIEN_HEAR_DIST = 10;
    public static final int FOA_SHOT = 1;
    public static final int FOA_MELEE = 2;
    public static final int FOA_EXPLOSION = 3;
    public static final int FOA_CRUSHED = 4;
    public static final int FOA_NERVE_GAS = 5;
    public static final int FOA_MERGED = 6;
    public static final int FOA_FIRE = 7;

    public static String GetUnitDataRequest(int gameid, String gamecode, String login, String pwd) {
        return "cmd=unitdata&version=" + Statics.COMMS_VERSION + "&getput=" + "get" + "&gid=" + gameid + "&gc=" + gamecode + "&login=" + AbstractCommFuncs.URLEncodeString(login) + "&pwd=" + AbstractCommFuncs.URLEncodeString(pwd);
    }

    public static ArrayList<UnitData> DecodeUnitDataResponse(String response) throws IOException {
        response = AbstractCommFuncs.URLDecodeString(response);
        String[] data = response.split("\\|", -1);
        int pos = 0;
        int num = 0;
        UnitData unit = null;
        ArrayList<UnitData> al_units = new ArrayList<UnitData>();
        do {
            if (data[pos].equalsIgnoreCase("qty")) {
                int u = NumberFunctions.ParseInt(data[pos + 1]);
                unit = new UnitData(u);
                pos += 2;
                continue;
            }
            if (data[pos].equalsIgnoreCase("unit")) {
                unit = new UnitData(num);
                unit.unitid = NumberFunctions.ParseInt(data[pos + 1]);
                unit.unitcode = data[pos + 2];
                unit.name = data[pos + 3];
                unit.setSide(NumberFunctions.ParseByte(data[pos + 4]));
                unit.setStatus(NumberFunctions.ParseByte(data[pos + 5]));
                byte x = NumberFunctions.ParseByte(data[pos + 6]);
                byte z = NumberFunctions.ParseByte(data[pos + 7]);
                unit.setAngle(NumberFunctions.ParseInt(data[pos + 8]));
                unit.model_type = NumberFunctions.ParseByte(data[pos + 9]);
                unit.setAPs(NumberFunctions.ParseByte(data[pos + 10]));
                unit.max_aps = NumberFunctions.ParseShort(data[pos + 11]);
                unit.current_item_id_TMP = NumberFunctions.ParseInt(data[pos + 12]);
                unit.protection = NumberFunctions.ParseShort(data[pos + 13]);
                unit.opp_fire_01 = NumberFunctions.ParseByte(data[pos + 14]);
                unit.shot_skill = NumberFunctions.ParseShort(data[pos + 15]);
                unit.combat_skill = NumberFunctions.ParseShort(data[pos + 16]);
                unit.can_use_equipment = NumberFunctions.ParseInt(data[pos + 17]) == 1;
                unit.strength = NumberFunctions.ParseShort(data[pos + 18]);
                unit.setHealth(NumberFunctions.ParseShort(data[pos + 19]));
                unit.opp_fire_aps_req = NumberFunctions.ParseShort(data[pos + 20]);
                unit.max_health = NumberFunctions.ParseShort(data[pos + 21]);
                unit.order_by = NumberFunctions.ParseInt(data[pos + 22]);
                unit.curr_morale = NumberFunctions.ParseShort(data[pos + 24]);
                unit.curr_energy = NumberFunctions.ParseShort(data[pos + 25]);
                unit.panicked = NumberFunctions.ParseByte(data[pos + 26]);
                unit.armour_type_id = NumberFunctions.ParseByte(data[pos + 27]);
                unit.can_deploy = NumberFunctions.ParseByte(data[pos + 28]);
                try {
                    unit.setAIType(NumberFunctions.ParseInt(data[pos + 31]));
                    unit.unit_type = NumberFunctions.ParseByte(data[pos + 32]);
                    unit.on_fire = NumberFunctions.ParseByte(data[pos + 33]);
                    unit.can_equip = NumberFunctions.ParseByte(data[pos + 34]);
                    unit.skillid = NumberFunctions.ParseByte(data[pos + 35]);
                    pos += 35;
                }
                catch (Exception ex) {
                    pos += 29;
                }
                unit.setTargetMapLocation(null, x, z, null);
                al_units.add(unit);
                ++num;
                continue;
            }
            ++pos;
        } while (pos < data.length);
        if (al_units.size() == 0) {
            throw new RuntimeException("Error decoding unit data");
        }
        return al_units;
    }

    public static String GetUnitUpdateRequest(UnitData unit) {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(unit.unitid) + "|");
        str.append(String.valueOf(unit.unitcode) + "|");
        str.append(String.valueOf(unit.getMapX()) + "|");
        str.append(String.valueOf(unit.getMapY()) + "|");
        str.append(String.valueOf(unit.getAngle()) + "|");
        str.append(String.valueOf(unit.getStatus()) + "|");
        if (unit.current_item != null) {
            str.append(String.valueOf(unit.current_item.equip_id) + "|");
        } else {
            str.append("0|");
        }
        str.append(String.valueOf(unit.getAPs()) + "|");
        str.append(String.valueOf(unit.getHealth()) + "|");
        str.append("0|");
        str.append(String.valueOf(System.currentTimeMillis()) + "|");
        str.append(String.valueOf(unit.getMaxHealth()) + "|");
        str.append(String.valueOf(unit.combat_skill) + "|");
        str.append(String.valueOf(unit.strength) + "|");
        str.append(String.valueOf(unit.armour_type_id) + "|");
        str.append(String.valueOf(unit.shot_skill) + "|");
        str.append("0|");
        str.append(String.valueOf(unit.protection) + "|");
        str.append("0|");
        str.append(String.valueOf(unit.on_fire) + "|");
        return "cmd=unitdata&version=" + Statics.COMMS_VERSION + "&getput=" + "put" + "&data=" + str.toString();
    }
}

